/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.introspect;

import com.amazonaws.com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.amazonaws.com.fasterxml.jackson.annotation.JacksonInject;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonBackReference;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonCreator;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonFilter;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonFormat;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonGetter;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonIgnore;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonInclude;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonManagedReference;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonProperty;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonRawValue;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonRootName;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonSetter;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonSubTypes;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonTypeId;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonTypeName;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonValue;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonView;
import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.KeyDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.PropertyName;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonValueInstantiator;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.NoClass;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.NamedType;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.RawSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    @Override
    public boolean isAnnotationBundle(Annotation ann) {
        return ann.annotationType().getAnnotation(JacksonAnnotationsInside.class) != null;
    }

    @Override
    public PropertyName findRootName(AnnotatedClass ac) {
        JsonRootName ann = ac.getAnnotation(JsonRootName.class);
        if (ann == null) {
            return null;
        }
        return new PropertyName(ann.value());
    }

    @Override
    public String[] findPropertiesToIgnore(Annotated ac) {
        JsonIgnoreProperties ignore = ac.getAnnotation(JsonIgnoreProperties.class);
        return ignore == null ? null : ignore.value();
    }

    @Override
    public Boolean findIgnoreUnknownProperties(AnnotatedClass ac) {
        JsonIgnoreProperties ignore = ac.getAnnotation(JsonIgnoreProperties.class);
        return ignore == null ? null : Boolean.valueOf(ignore.ignoreUnknown());
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass ac) {
        JsonIgnoreType ignore = ac.getAnnotation(JsonIgnoreType.class);
        return ignore == null ? null : Boolean.valueOf(ignore.value());
    }

    @Override
    public Object findFilterId(AnnotatedClass ac) {
        String id;
        JsonFilter ann = ac.getAnnotation(JsonFilter.class);
        if (ann != null && (id = ann.value()).length() > 0) {
            return id;
        }
        return null;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass ac) {
        JsonNaming ann = ac.getAnnotation(JsonNaming.class);
        return ann == null ? null : ann.value();
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
        JsonAutoDetect ann = ac.getAnnotation(JsonAutoDetect.class);
        return ann == null ? checker : checker.with(ann);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember member) {
        JsonManagedReference ref1 = member.getAnnotation(JsonManagedReference.class);
        if (ref1 != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(ref1.value());
        }
        JsonBackReference ref2 = member.getAnnotation(JsonBackReference.class);
        if (ref2 != null) {
            return AnnotationIntrospector.ReferenceProperty.back(ref2.value());
        }
        return null;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember member) {
        JsonUnwrapped ann = member.getAnnotation(JsonUnwrapped.class);
        if (ann == null || !ann.enabled()) {
            return null;
        }
        String prefix = ann.prefix();
        String suffix = ann.suffix();
        return NameTransformer.simpleTransformer(prefix, suffix);
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember m) {
        return this._isIgnorable(m);
    }

    @Override
    public Object findInjectableValueId(AnnotatedMember annotatedMember) {
        JacksonInject jacksonInject = annotatedMember.getAnnotation(JacksonInject.class);
        if (jacksonInject == null) {
            return null;
        }
        String string = jacksonInject.value();
        if (string.length() == 0) {
            if (!(annotatedMember instanceof AnnotatedMethod)) {
                return annotatedMember.getRawType().getName();
            }
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotatedMember;
            if (annotatedMethod.getParameterCount() == 0) {
                return annotatedMember.getRawType().getName();
            }
            return annotatedMethod.getRawParameterType(0).getName();
        }
        return string;
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        return this._findTypeResolver(config, ac, baseType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType baseType) {
        if (baseType.isContainerType()) {
            return null;
        }
        return this._findTypeResolver(config, am, baseType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (!javaType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + javaType + ")");
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    @Override
    public List<NamedType> findSubtypes(Annotated a) {
        JsonSubTypes t = a.getAnnotation(JsonSubTypes.class);
        if (t == null) {
            return null;
        }
        JsonSubTypes.Type[] types = t.value();
        ArrayList<NamedType> result = new ArrayList<NamedType>(types.length);
        for (JsonSubTypes.Type type : types) {
            result.add(new NamedType(type.value(), type.name()));
        }
        return result;
    }

    @Override
    public String findTypeName(AnnotatedClass annotatedClass) {
        JsonTypeName jsonTypeName = annotatedClass.getAnnotation(JsonTypeName.class);
        return jsonTypeName == null ? null : jsonTypeName.value();
    }

    @Override
    public Object findSerializer(Annotated annotated) {
        Object object;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (object = jsonSerialize.using()) != JsonSerializer.None.class) {
            return object;
        }
        object = annotated.getAnnotation(JsonRawValue.class);
        if (object != null && object.value()) {
            Class<?> clazz = annotated.getRawType();
            return new RawSerializer(clazz);
        }
        return null;
    }

    @Override
    public Class<? extends JsonSerializer<?>> findKeySerializer(Annotated a) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.keyUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public Class<? extends JsonSerializer<?>> findContentSerializer(Annotated a) {
        Class<? extends JsonSerializer<?>> serClass;
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null && (serClass = ann.contentUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    @Override
    public JsonInclude.Include findSerializationInclusion(Annotated a, JsonInclude.Include defValue) {
        JsonInclude inc = a.getAnnotation(JsonInclude.class);
        if (inc != null) {
            return inc.value();
        }
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        if (ann != null) {
            JsonSerialize.Inclusion i2 = ann.include();
            switch (i2) {
                case ALWAYS: {
                    return JsonInclude.Include.ALWAYS;
                }
                case NON_NULL: {
                    return JsonInclude.Include.NON_NULL;
                }
                case NON_DEFAULT: {
                    return JsonInclude.Include.NON_DEFAULT;
                }
                case NON_EMPTY: {
                    return JsonInclude.Include.NON_EMPTY;
                }
            }
        }
        return defValue;
    }

    @Override
    public Class<?> findSerializationType(Annotated annotated) {
        Class<?> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.as()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findSerializationKeyType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.keyAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findSerializationContentType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.contentAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated a) {
        JsonSerialize ann = a.getAnnotation(JsonSerialize.class);
        return ann == null ? null : ann.typing();
    }

    @Override
    public Class<?>[] findViews(Annotated annotated) {
        JsonView jsonView = annotated.getAnnotation(JsonView.class);
        return jsonView == null ? null : jsonView.value();
    }

    @Override
    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        return annotatedMember.hasAnnotation(JsonTypeId.class);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        JsonIdentityInfo jsonIdentityInfo = annotated.getAnnotation(JsonIdentityInfo.class);
        if (jsonIdentityInfo == null || jsonIdentityInfo.generator() == ObjectIdGenerators.None.class) {
            return null;
        }
        return new ObjectIdInfo(jsonIdentityInfo.property(), jsonIdentityInfo.scope(), jsonIdentityInfo.generator());
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated annotated, ObjectIdInfo objectIdInfo) {
        JsonIdentityReference jsonIdentityReference = annotated.getAnnotation(JsonIdentityReference.class);
        if (jsonIdentityReference != null) {
            objectIdInfo = objectIdInfo.withAlwaysAsId(jsonIdentityReference.alwaysAsId());
        }
        return objectIdInfo;
    }

    @Override
    public JsonFormat.Value findFormat(AnnotatedMember member) {
        return this.findFormat(member);
    }

    @Override
    public JsonFormat.Value findFormat(Annotated annotated) {
        JsonFormat ann = annotated.getAnnotation(JsonFormat.class);
        return ann == null ? null : new JsonFormat.Value(ann);
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        JsonPropertyOrder jsonPropertyOrder = annotatedClass.getAnnotation(JsonPropertyOrder.class);
        return jsonPropertyOrder == null ? null : jsonPropertyOrder.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(AnnotatedClass annotatedClass) {
        JsonPropertyOrder jsonPropertyOrder = annotatedClass.getAnnotation(JsonPropertyOrder.class);
        return jsonPropertyOrder == null ? null : Boolean.valueOf(jsonPropertyOrder.alphabetic());
    }

    @Override
    public PropertyName findNameForSerialization(Annotated a) {
        String name = a instanceof AnnotatedField ? this.findSerializationName((AnnotatedField)a) : (a instanceof AnnotatedMethod ? this.findSerializationName((AnnotatedMethod)a) : null);
        if (name != null) {
            if (name.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(name);
        }
        return null;
    }

    @Override
    public String findSerializationName(AnnotatedField annotatedField) {
        JsonProperty jsonProperty = annotatedField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedField.hasAnnotation(JsonSerialize.class) || annotatedField.hasAnnotation(JsonView.class)) {
            return "";
        }
        return null;
    }

    @Override
    public String findSerializationName(AnnotatedMethod annotatedMethod) {
        JsonGetter jsonGetter = annotatedMethod.getAnnotation(JsonGetter.class);
        if (jsonGetter != null) {
            return jsonGetter.value();
        }
        JsonProperty jsonProperty = annotatedMethod.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedMethod.hasAnnotation(JsonSerialize.class) || annotatedMethod.hasAnnotation(JsonView.class)) {
            return "";
        }
        return null;
    }

    @Override
    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        JsonValue jsonValue = annotatedMethod.getAnnotation(JsonValue.class);
        return jsonValue != null && jsonValue.value();
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findDeserializer(Annotated annotated) {
        Class<? extends JsonDeserializer<?>> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.using()) != JsonDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<? extends KeyDeserializer> findKeyDeserializer(Annotated annotated) {
        Class<? extends KeyDeserializer> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.keyUsing()) != KeyDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findContentDeserializer(Annotated annotated) {
        Class<? extends JsonDeserializer<?>> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.contentUsing()) != JsonDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.as()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationKeyType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.keyAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationContentType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.contentAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass annotatedClass) {
        JsonValueInstantiator jsonValueInstantiator = annotatedClass.getAnnotation(JsonValueInstantiator.class);
        return jsonValueInstantiator == null ? null : jsonValueInstantiator.value();
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass annotatedClass) {
        JsonDeserialize jsonDeserialize = annotatedClass.getAnnotation(JsonDeserialize.class);
        return jsonDeserialize == null || jsonDeserialize.builder() == NoClass.class ? null : jsonDeserialize.builder();
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        JsonPOJOBuilder ann = ac.getAnnotation(JsonPOJOBuilder.class);
        return ann == null ? null : new JsonPOJOBuilder.Value(ann);
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated a) {
        String name = a instanceof AnnotatedField ? this.findDeserializationName((AnnotatedField)a) : (a instanceof AnnotatedMethod ? this.findDeserializationName((AnnotatedMethod)a) : (a instanceof AnnotatedParameter ? this.findDeserializationName((AnnotatedParameter)a) : null));
        if (name != null) {
            if (name.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(name);
        }
        return null;
    }

    @Override
    public String findDeserializationName(AnnotatedMethod annotatedMethod) {
        JsonSetter jsonSetter = annotatedMethod.getAnnotation(JsonSetter.class);
        if (jsonSetter != null) {
            return jsonSetter.value();
        }
        JsonProperty jsonProperty = annotatedMethod.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedMethod.hasAnnotation(JsonDeserialize.class) || annotatedMethod.hasAnnotation(JsonView.class) || annotatedMethod.hasAnnotation(JsonBackReference.class) || annotatedMethod.hasAnnotation(JsonManagedReference.class)) {
            return "";
        }
        return null;
    }

    @Override
    public String findDeserializationName(AnnotatedField annotatedField) {
        JsonProperty jsonProperty = annotatedField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedField.hasAnnotation(JsonDeserialize.class) || annotatedField.hasAnnotation(JsonView.class) || annotatedField.hasAnnotation(JsonBackReference.class) || annotatedField.hasAnnotation(JsonManagedReference.class)) {
            return "";
        }
        return null;
    }

    @Override
    public String findDeserializationName(AnnotatedParameter param) {
        JsonProperty pann;
        if (param != null && (pann = param.getAnnotation(JsonProperty.class)) != null) {
            return pann.value();
        }
        return null;
    }

    @Override
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.hasAnnotation(JsonAnySetter.class);
    }

    @Override
    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.hasAnnotation(JsonAnyGetter.class);
    }

    @Override
    public boolean hasCreatorAnnotation(Annotated annotated) {
        return annotated.hasAnnotation(JsonCreator.class);
    }

    protected boolean _isIgnorable(Annotated annotated) {
        JsonIgnore jsonIgnore = annotated.getAnnotation(JsonIgnore.class);
        return jsonIgnore != null && jsonIgnore.value();
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) {
        TypeIdResolver typeIdResolver;
        StdTypeResolverBuilder stdTypeResolverBuilder;
        JsonTypeInfo jsonTypeInfo = annotated.getAnnotation(JsonTypeInfo.class);
        JsonTypeResolver jsonTypeResolver = annotated.getAnnotation(JsonTypeResolver.class);
        if (jsonTypeResolver != null) {
            if (jsonTypeInfo == null) {
                return null;
            }
            stdTypeResolverBuilder = mapperConfig.typeResolverBuilderInstance(annotated, jsonTypeResolver.value());
        } else {
            if (jsonTypeInfo == null) {
                return null;
            }
            if (jsonTypeInfo.use() == JsonTypeInfo.Id.NONE) {
                return this._constructNoTypeResolverBuilder();
            }
            stdTypeResolverBuilder = this._constructStdTypeResolverBuilder();
        }
        JsonTypeIdResolver jsonTypeIdResolver = annotated.getAnnotation(JsonTypeIdResolver.class);
        TypeIdResolver typeIdResolver2 = typeIdResolver = jsonTypeIdResolver == null ? null : mapperConfig.typeIdResolverInstance(annotated, jsonTypeIdResolver.value());
        if (typeIdResolver != null) {
            typeIdResolver.init(javaType);
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.init(jsonTypeInfo.use(), typeIdResolver);
        JsonTypeInfo.As as = jsonTypeInfo.include();
        if (as == JsonTypeInfo.As.EXTERNAL_PROPERTY && annotated instanceof AnnotatedClass) {
            as = JsonTypeInfo.As.PROPERTY;
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.inclusion(as);
        stdTypeResolverBuilder = stdTypeResolverBuilder.typeProperty(jsonTypeInfo.property());
        Class<?> clazz = jsonTypeInfo.defaultImpl();
        if (clazz != JsonTypeInfo.None.class) {
            stdTypeResolverBuilder = stdTypeResolverBuilder.defaultImpl(clazz);
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.typeIdVisibility(jsonTypeInfo.visible());
        return stdTypeResolverBuilder;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    protected StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }
}

