/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.node;

import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.databind.JsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.ContainerNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.amazonaws.com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class ObjectNode
extends ContainerNode<ObjectNode> {
    protected Map<String, JsonNode> _children = null;

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children == null ? ContainerNode.NoNodesIterator.instance() : this._children.values().iterator();
    }

    @Override
    public JsonNode get(String fieldName) {
        if (this._children != null) {
            return this._children.get(fieldName);
        }
        return null;
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        if (this._children == null) {
            return NoFieldsIterator.instance;
        }
        return this._children.entrySet().iterator();
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeStartObject();
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                jg.writeFieldName(en.getKey());
                ((BaseJsonNode)en.getValue()).serialize(jg, provider);
            }
        }
        jg.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jg, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForObject(this, jg);
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                jg.writeFieldName(en.getKey());
                ((BaseJsonNode)en.getValue()).serialize(jg, provider);
            }
        }
        typeSer.writeTypeSuffixForObject(this, jg);
    }

    public JsonNode replace(String fieldName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._put(fieldName, value);
    }

    protected Map<String, JsonNode> _createMap() {
        return new LinkedHashMap<String, JsonNode>();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ObjectNode other = (ObjectNode)o;
        if (other.size() != this.size()) {
            return false;
        }
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                String key = en.getKey();
                JsonNode value = en.getValue();
                JsonNode otherValue = other.get(key);
                if (otherValue != null && otherValue.equals(value)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this._children == null ? -1 : ((Object)this._children).hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + (this.size() << 4));
        stringBuilder.append("{");
        if (this._children != null) {
            int n = 0;
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                ++n;
                TextNode.appendQuoted(stringBuilder, entry.getKey());
                stringBuilder.append(':');
                stringBuilder.append(entry.getValue().toString());
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private final JsonNode _put(String fieldName, JsonNode value) {
        if (this._children == null) {
            this._children = this._createMap();
        }
        return this._children.put(fieldName, value);
    }

    protected static class NoFieldsIterator
    implements Iterator<Map.Entry<String, JsonNode>> {
        static final NoFieldsIterator instance = new NoFieldsIterator();

        private NoFieldsIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, JsonNode> next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

