/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.XpathUtils;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(DefaultErrorResponseHandler.class);
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> list) {
        this.unmarshallerList = list;
    }

    @Override
    public AmazonServiceException handle(HttpResponse httpResponse) throws Exception {
        Document document;
        String string = "";
        try {
            string = IOUtils.toString(httpResponse.getContent());
        }
        catch (IOException iOException) {
            if (log.isDebugEnabled()) {
                log.debug("Failed in reading the error response", iOException);
            }
            return this.newAmazonServiceException("Unable to unmarshall error response", httpResponse, iOException);
        }
        try {
            document = XpathUtils.documentFrom(string);
        }
        catch (Exception exception) {
            return this.newAmazonServiceException(String.format("Unable to unmarshall error response (%s)", string), httpResponse, exception);
        }
        for (Unmarshaller<AmazonServiceException, Node> unmarshaller : this.unmarshallerList) {
            AmazonServiceException amazonServiceException = unmarshaller.unmarshall(document);
            if (amazonServiceException == null) continue;
            amazonServiceException.setStatusCode(httpResponse.getStatusCode());
            return amazonServiceException;
        }
        throw new AmazonClientException("Unable to unmarshall error response from service");
    }

    private AmazonServiceException newAmazonServiceException(String string, HttpResponse httpResponse, Exception exception) {
        AmazonServiceException amazonServiceException = new AmazonServiceException(string, exception);
        int n = httpResponse.getStatusCode();
        amazonServiceException.setErrorCode(n + " " + httpResponse.getStatusText());
        amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Unknown);
        amazonServiceException.setStatusCode(n);
        return amazonServiceException;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

