/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.json.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    private List<? extends JsonErrorUnmarshaller> unmarshallerList;

    public JsonErrorResponseHandler(List<? extends JsonErrorUnmarshaller> list) {
        this.unmarshallerList = list;
    }

    @Override
    public AmazonServiceException handle(HttpResponse httpResponse) throws Exception {
        JSONObject jSONObject;
        String string;
        String string2 = this.readStreamContents(httpResponse.getContent());
        try {
            string = string2;
            if (string.length() == 0 || string.trim().length() == 0) {
                string = "{}";
            }
            jSONObject = new JSONObject(string);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to parse error response: '" + string2 + "'", exception);
        }
        string = this.parseErrorTypeFromHeader(httpResponse);
        AmazonServiceException amazonServiceException = this.runErrorUnmarshallers(httpResponse, jSONObject, string);
        if (amazonServiceException == null) {
            return null;
        }
        amazonServiceException.setServiceName(httpResponse.getRequest().getServiceName());
        amazonServiceException.setStatusCode(httpResponse.getStatusCode());
        if (httpResponse.getStatusCode() < 500) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Client);
        } else {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Service);
        }
        for (Map.Entry<String, String> entry : httpResponse.getHeaders().entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("X-Amzn-RequestId")) continue;
            amazonServiceException.setRequestId(entry.getValue());
        }
        return amazonServiceException;
    }

    private AmazonServiceException runErrorUnmarshallers(HttpResponse httpResponse, JSONObject jSONObject, String string) throws Exception {
        for (JsonErrorUnmarshaller jsonErrorUnmarshaller : this.unmarshallerList) {
            if (!jsonErrorUnmarshaller.match(string, jSONObject)) continue;
            AmazonServiceException amazonServiceException = jsonErrorUnmarshaller.unmarshall(jSONObject);
            amazonServiceException.setStatusCode(httpResponse.getStatusCode());
            return amazonServiceException;
        }
        return null;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private String readStreamContents(InputStream inputStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            try {
                inputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new AmazonClientException("Unable to read error response: " + exception.getMessage(), exception);
        }
    }

    private String parseErrorTypeFromHeader(HttpResponse httpResponse) {
        int n;
        String string = httpResponse.getHeaders().get(X_AMZN_ERROR_TYPE);
        if (string != null && (n = string.indexOf(58)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

