/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.client.methods;

import com.amazonaws.org.apache.http.ProtocolVersion;
import com.amazonaws.org.apache.http.RequestLine;
import com.amazonaws.org.apache.http.client.methods.AbortableHttpRequest;
import com.amazonaws.org.apache.http.client.methods.HttpUriRequest;
import com.amazonaws.org.apache.http.client.utils.CloneUtils;
import com.amazonaws.org.apache.http.conn.ClientConnectionRequest;
import com.amazonaws.org.apache.http.conn.ConnectionReleaseTrigger;
import com.amazonaws.org.apache.http.message.AbstractHttpMessage;
import com.amazonaws.org.apache.http.message.BasicRequestLine;
import com.amazonaws.org.apache.http.message.HeaderGroup;
import com.amazonaws.org.apache.http.params.HttpParams;
import com.amazonaws.org.apache.http.params.HttpProtocolParams;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class HttpRequestBase
extends AbstractHttpMessage
implements AbortableHttpRequest,
HttpUriRequest,
Cloneable {
    private Lock abortLock = new ReentrantLock();
    private volatile boolean aborted;
    private URI uri;
    private ClientConnectionRequest connRequest;
    private ConnectionReleaseTrigger releaseTrigger;

    public abstract String getMethod();

    public ProtocolVersion getProtocolVersion() {
        return HttpProtocolParams.getVersion(this.getParams());
    }

    public URI getURI() {
        return this.uri;
    }

    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uri = this.getURI();
        String uritext = null;
        if (uri != null) {
            uritext = uri.toASCIIString();
        }
        if (uritext == null || uritext.length() == 0) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionRequest(ClientConnectionRequest connRequest) throws IOException {
        if (this.aborted) {
            throw new IOException("Request already aborted");
        }
        this.abortLock.lock();
        try {
            this.connRequest = connRequest;
        }
        finally {
            this.abortLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReleaseTrigger(ConnectionReleaseTrigger releaseTrigger) throws IOException {
        if (this.aborted) {
            throw new IOException("Request already aborted");
        }
        this.abortLock.lock();
        try {
            this.releaseTrigger = releaseTrigger;
        }
        finally {
            this.abortLock.unlock();
        }
    }

    private void cleanup() {
        if (this.connRequest != null) {
            this.connRequest.abortRequest();
            this.connRequest = null;
        }
        if (this.releaseTrigger != null) {
            try {
                this.releaseTrigger.abortConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.releaseTrigger = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.aborted) {
            return;
        }
        this.abortLock.lock();
        try {
            this.aborted = true;
            this.cleanup();
        }
        finally {
            this.abortLock.unlock();
        }
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Object clone() throws CloneNotSupportedException {
        HttpRequestBase clone = (HttpRequestBase)super.clone();
        clone.abortLock = new ReentrantLock();
        clone.aborted = false;
        clone.releaseTrigger = null;
        clone.connRequest = null;
        clone.headergroup = (HeaderGroup)CloneUtils.clone(this.headergroup);
        clone.params = (HttpParams)CloneUtils.clone(this.params);
        return clone;
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

