/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.chrono;

import com.amazonaws.org.joda.time.DateTimeFieldType;
import com.amazonaws.org.joda.time.DurationField;
import com.amazonaws.org.joda.time.chrono.BasicChronology;
import com.amazonaws.org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfYearDateTimeField
extends PreciseDurationDateTimeField {
    private final BasicChronology iChronology;

    BasicDayOfYearDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.dayOfYear(), durationField);
        this.iChronology = basicChronology;
    }

    public int get(long l) {
        return this.iChronology.getDayOfYear(l);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return this.iChronology.getDaysInYearMax();
    }

    public int getMaximumValue(long l) {
        int n = this.iChronology.getYear(l);
        return this.iChronology.getDaysInYear(n);
    }

    protected int getMaximumValueForSet(long l, int n) {
        int n2 = this.iChronology.getDaysInYearMax() - 1;
        return n > n2 || n < 1 ? this.getMaximumValue(l) : n2;
    }
}

