/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.chrono;

import com.amazonaws.org.joda.time.DateTimeFieldType;
import com.amazonaws.org.joda.time.DurationField;
import com.amazonaws.org.joda.time.chrono.BasicChronology;
import com.amazonaws.org.joda.time.field.PreciseDurationDateTimeField;

final class BasicWeekOfWeekyearDateTimeField
extends PreciseDurationDateTimeField {
    private final BasicChronology iChronology;

    BasicWeekOfWeekyearDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.weekOfWeekyear(), durationField);
        this.iChronology = basicChronology;
    }

    public int get(long l) {
        return this.iChronology.getWeekOfWeekyear(l);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.weekyears();
    }

    public long roundFloor(long l) {
        return super.roundFloor(l + 259200000L) - 259200000L;
    }

    public long roundCeiling(long l) {
        return super.roundCeiling(l + 259200000L) - 259200000L;
    }

    public long remainder(long l) {
        return super.remainder(l + 259200000L);
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 53;
    }

    public int getMaximumValue(long l) {
        int n = this.iChronology.getWeekyear(l);
        return this.iChronology.getWeeksInYear(n);
    }

    protected int getMaximumValueForSet(long l, int n) {
        return n > 52 ? this.getMaximumValue(l) : 52;
    }
}

