/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateIdentityPoolRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String identityPoolName;
    private Boolean allowUnauthenticatedIdentities;
    private Map<String, String> supportedLoginProviders;
    private String developerProviderName;

    public String getIdentityPoolName() {
        return this.identityPoolName;
    }

    public void setIdentityPoolName(String string) {
        this.identityPoolName = string;
    }

    public CreateIdentityPoolRequest withIdentityPoolName(String string) {
        this.identityPoolName = string;
        return this;
    }

    public Boolean isAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public void setAllowUnauthenticatedIdentities(Boolean bl) {
        this.allowUnauthenticatedIdentities = bl;
    }

    public CreateIdentityPoolRequest withAllowUnauthenticatedIdentities(Boolean bl) {
        this.allowUnauthenticatedIdentities = bl;
        return this;
    }

    public Boolean getAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Map<String, String> getSupportedLoginProviders() {
        if (this.supportedLoginProviders == null) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        return this.supportedLoginProviders;
    }

    public void setSupportedLoginProviders(Map<String, String> map) {
        this.supportedLoginProviders = map;
    }

    public CreateIdentityPoolRequest withSupportedLoginProviders(Map<String, String> map) {
        this.setSupportedLoginProviders(map);
        return this;
    }

    public CreateIdentityPoolRequest addSupportedLoginProvidersEntry(String string, String string2) {
        if (null == this.supportedLoginProviders) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        if (this.supportedLoginProviders.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.supportedLoginProviders.put(string, string2);
        return this;
    }

    public CreateIdentityPoolRequest clearSupportedLoginProvidersEntries() {
        this.supportedLoginProviders = null;
        return this;
    }

    public String getDeveloperProviderName() {
        return this.developerProviderName;
    }

    public void setDeveloperProviderName(String string) {
        this.developerProviderName = string;
    }

    public CreateIdentityPoolRequest withDeveloperProviderName(String string) {
        this.developerProviderName = string;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getIdentityPoolName() != null) {
            stringBuilder.append("IdentityPoolName: " + this.getIdentityPoolName() + ",");
        }
        if (this.isAllowUnauthenticatedIdentities() != null) {
            stringBuilder.append("AllowUnauthenticatedIdentities: " + this.isAllowUnauthenticatedIdentities() + ",");
        }
        if (this.getSupportedLoginProviders() != null) {
            stringBuilder.append("SupportedLoginProviders: " + this.getSupportedLoginProviders() + ",");
        }
        if (this.getDeveloperProviderName() != null) {
            stringBuilder.append("DeveloperProviderName: " + this.getDeveloperProviderName());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getIdentityPoolName() == null ? 0 : this.getIdentityPoolName().hashCode());
        n = 31 * n + (this.isAllowUnauthenticatedIdentities() == null ? 0 : this.isAllowUnauthenticatedIdentities().hashCode());
        n = 31 * n + (this.getSupportedLoginProviders() == null ? 0 : ((Object)this.getSupportedLoginProviders()).hashCode());
        n = 31 * n + (this.getDeveloperProviderName() == null ? 0 : this.getDeveloperProviderName().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CreateIdentityPoolRequest)) {
            return false;
        }
        CreateIdentityPoolRequest createIdentityPoolRequest = (CreateIdentityPoolRequest)object;
        if (createIdentityPoolRequest.getIdentityPoolName() == null ^ this.getIdentityPoolName() == null) {
            return false;
        }
        if (createIdentityPoolRequest.getIdentityPoolName() != null && !createIdentityPoolRequest.getIdentityPoolName().equals(this.getIdentityPoolName())) {
            return false;
        }
        if (createIdentityPoolRequest.isAllowUnauthenticatedIdentities() == null ^ this.isAllowUnauthenticatedIdentities() == null) {
            return false;
        }
        if (createIdentityPoolRequest.isAllowUnauthenticatedIdentities() != null && !createIdentityPoolRequest.isAllowUnauthenticatedIdentities().equals(this.isAllowUnauthenticatedIdentities())) {
            return false;
        }
        if (createIdentityPoolRequest.getSupportedLoginProviders() == null ^ this.getSupportedLoginProviders() == null) {
            return false;
        }
        if (createIdentityPoolRequest.getSupportedLoginProviders() != null && !((Object)createIdentityPoolRequest.getSupportedLoginProviders()).equals(this.getSupportedLoginProviders())) {
            return false;
        }
        if (createIdentityPoolRequest.getDeveloperProviderName() == null ^ this.getDeveloperProviderName() == null) {
            return false;
        }
        return createIdentityPoolRequest.getDeveloperProviderName() == null || createIdentityPoolRequest.getDeveloperProviderName().equals(this.getDeveloperProviderName());
    }
}

