/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.javax.xml.stream.events.XMLEvent;
import com.amazonaws.services.securitytoken.model.FederatedUser;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class FederatedUserStaxUnmarshaller
implements Unmarshaller<FederatedUser, StaxUnmarshallerContext> {
    private static FederatedUserStaxUnmarshaller instance;

    @Override
    public FederatedUser unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        FederatedUser federatedUser = new FederatedUser();
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            n2 += 2;
        }
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return federatedUser;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("FederatedUserId", n2)) {
                    federatedUser.setFederatedUserId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (!staxUnmarshallerContext.testExpression("Arn", n2)) continue;
                federatedUser.setArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return federatedUser;
    }

    public static FederatedUserStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FederatedUserStaxUnmarshaller();
        }
        return instance;
    }
}

