/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;

public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JSONObject> {
    public JsonErrorUnmarshaller() {
    }

    protected JsonErrorUnmarshaller(Class<? extends AmazonServiceException> clazz) {
        super(clazz);
    }

    @Override
    public AmazonServiceException unmarshall(JSONObject jSONObject) throws Exception {
        String string = this.parseMessage(jSONObject);
        String string2 = this.parseErrorCode(jSONObject);
        if ((null == string || string.isEmpty()) && (null == string2 || string2.isEmpty())) {
            throw new AmazonClientException("Neither error message nor error code is found in the error response payload.");
        }
        AmazonServiceException amazonServiceException = this.newException(string);
        amazonServiceException.setErrorCode(string2);
        return amazonServiceException;
    }

    public String parseMessage(JSONObject jSONObject) throws Exception {
        return this.parseMember("message", jSONObject);
    }

    public String parseMember(String string, JSONObject jSONObject) throws JSONException {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        String string3 = string.substring(0, 1).toUpperCase() + string.substring(1);
        String string4 = "";
        if (jSONObject.has(string3)) {
            string4 = jSONObject.getString(string3);
        } else if (jSONObject.has(string2)) {
            string4 = jSONObject.getString(string2);
        }
        return string4;
    }

    public String parseErrorCode(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("__type")) {
            String string = jSONObject.getString("__type");
            int n = string.lastIndexOf("#");
            return string.substring(n + 1);
        }
        return null;
    }

    public boolean match(String string, JSONObject jSONObject) throws Exception {
        return true;
    }
}

