/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser;

import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.amazonaws.com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.MapperFeature;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BasicDeserializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.amazonaws.com.fasterxml.jackson.databind.deser.Deserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.FieldProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.SetterlessProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.ThrowableDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.type.ClassKey;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeFactory;
import com.amazonaws.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.amazonaws.com.fasterxml.jackson.databind.util.ClassUtil;
import com.amazonaws.com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class BeanDeserializerFactory
extends BasicDeserializerFactory
implements Serializable {
    private static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    private static final Class<?>[] NO_VIEWS = new Class[0];
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(new DeserializerFactoryConfig());

    public BeanDeserializerFactory(DeserializerFactoryConfig config) {
        super(config);
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> deser = d.findBeanDeserializer(type, config, beanDesc);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        JavaType concreteType;
        DeserializationConfig config = ctxt.getConfig();
        JsonDeserializer<Object> custom = this._findCustomBeanDeserializer(type, config, beanDesc);
        if (custom != null) {
            return custom;
        }
        if (type.isThrowable()) {
            return this.buildThrowableDeserializer(ctxt, type, beanDesc);
        }
        if (type.isAbstract() && (concreteType = this.materializeAbstractType(config, beanDesc)) != null) {
            beanDesc = config.introspect(concreteType);
            return this.buildBeanDeserializer(ctxt, concreteType, beanDesc);
        }
        JsonDeserializer<Object> deser = this.findStdDeserializer(config, type);
        if (deser != null) {
            return deser;
        }
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        return this.buildBeanDeserializer(ctxt, type, beanDesc);
    }

    @Override
    public JsonDeserializer<Object> createBuilderBasedDeserializer(DeserializationContext ctxt, JavaType valueType, BeanDescription beanDesc, Class<?> builderClass) throws JsonMappingException {
        JavaType builderType = ctxt.constructType(builderClass);
        Object builderDesc = ctxt.getConfig().introspectForBuilder(builderType);
        return this.buildBuilderBasedDeserializer(ctxt, valueType, (BeanDescription)builderDesc);
    }

    protected JsonDeserializer<Object> findStdDeserializer(DeserializationConfig config, JavaType type) throws JsonMappingException {
        Class<?> cls = type.getRawClass();
        JsonDeserializer deser = (JsonDeserializer)_simpleDeserializers.get(new ClassKey(cls));
        if (deser != null) {
            return deser;
        }
        if (AtomicReference.class.isAssignableFrom(cls)) {
            TypeFactory tf = config.getTypeFactory();
            JavaType[] params = tf.findTypeParameters(type, AtomicReference.class);
            JavaType referencedType = params == null || params.length < 1 ? TypeFactory.unknownType() : params[0];
            JdkDeserializers.AtomicReferenceDeserializer d2 = new JdkDeserializers.AtomicReferenceDeserializer(referencedType);
            return d2;
        }
        JsonDeserializer<Object> d = this.optionalHandlers.findDeserializer(type, config);
        if (d != null) {
            return d;
        }
        return null;
    }

    protected JavaType materializeAbstractType(DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        JavaType abstractType = beanDesc.getType();
        for (AbstractTypeResolver r : this._factoryConfig.abstractTypeResolvers()) {
            JavaType concrete = r.resolveAbstractType(config, abstractType);
            if (concrete == null) continue;
            return concrete;
        }
        return null;
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        ValueInstantiator valueInstantiator = this.findValueInstantiator(ctxt, beanDesc);
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(ctxt, beanDesc);
        builder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(ctxt, beanDesc, builder);
        this.addObjectIdReader(ctxt, beanDesc, builder);
        this.addReferenceProperties(ctxt, beanDesc, builder);
        this.addInjectables(ctxt, beanDesc, builder);
        DeserializationConfig config = ctxt.getConfig();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config, beanDesc, builder);
            }
        }
        JsonDeserializer deserializer = type.isAbstract() && !valueInstantiator.canInstantiate() ? builder.buildAbstract() : builder.build();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    protected JsonDeserializer<Object> buildBuilderBasedDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addObjectIdReader(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addReferenceProperties(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addInjectables(deserializationContext, beanDescription, beanDeserializerBuilder);
        JsonPOJOBuilder.Value value = beanDescription.findPOJOBuilderConfig();
        String string = value == null ? "build" : value.buildMethodName;
        AnnotatedMethod annotatedMethod = beanDescription.findMethod(string, null);
        if (annotatedMethod != null && deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember());
        }
        beanDeserializerBuilder.setPOJOBuilder(annotatedMethod, value);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier object : this._factoryConfig.deserializerModifiers()) {
                beanDeserializerBuilder = object.updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        JsonDeserializer<?> jsonDeserializer = beanDeserializerBuilder.buildBuilderBased(javaType, string);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected void addObjectIdReader(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        ObjectIdGenerator objectIdGenerator;
        JavaType javaType;
        SettableBeanProperty settableBeanProperty;
        Object object;
        ObjectIdInfo objectIdInfo = beanDescription.getObjectIdInfo();
        if (objectIdInfo == null) {
            return;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            object = objectIdInfo.getPropertyName();
            settableBeanProperty = beanDeserializerBuilder.findProperty((String)object);
            if (settableBeanProperty == null) {
                throw new IllegalArgumentException("Invalid Object Id definition for " + beanDescription.getBeanClass().getName() + ": can not find property with name '" + object + "'");
            }
            javaType = settableBeanProperty.getType();
            objectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo.getScope());
        } else {
            object = deserializationContext.constructType(clazz);
            javaType = deserializationContext.getTypeFactory().findTypeParameters((JavaType)object, ObjectIdGenerator.class)[0];
            settableBeanProperty = null;
            objectIdGenerator = deserializationContext.objectIdGeneratorInstance(beanDescription.getClassInfo(), objectIdInfo);
        }
        object = deserializationContext.findRootValueDeserializer(javaType);
        beanDeserializerBuilder.setObjectIdReader(ObjectIdReader.construct(javaType, objectIdInfo.getPropertyName(), objectIdGenerator, object, settableBeanProperty));
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        Iterator<BeanDeserializerModifier> iterator;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(this.findValueInstantiator(deserializationContext, beanDescription));
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        AnnotatedMethod annotatedMethod = beanDescription.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (annotatedMethod != null && (iterator = this.constructSettableProperty(deserializationContext, beanDescription, (BeanPropertyDefinition)((Object)(jsonDeserializer = new SimpleBeanPropertyDefinition(annotatedMethod, "cause"))), annotatedMethod.getGenericParameterType(0))) != null) {
            beanDeserializerBuilder.addOrReplaceProperty((SettableBeanProperty)((Object)iterator), true);
        }
        beanDeserializerBuilder.addIgnorable("localizedMessage");
        beanDeserializerBuilder.addIgnorable("suppressed");
        beanDeserializerBuilder.addIgnorable("message");
        if (this._factoryConfig.hasDeserializerModifiers()) {
            jsonDeserializer = this._factoryConfig.deserializerModifiers().iterator();
            while (jsonDeserializer.hasNext()) {
                iterator = jsonDeserializer.next();
                beanDeserializerBuilder = ((BeanDeserializerModifier)((Object)iterator)).updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        if ((jsonDeserializer = beanDeserializerBuilder.build()) instanceof BeanDeserializer) {
            jsonDeserializer = new ThrowableDeserializer((BeanDeserializer)jsonDeserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(DeserializationContext ctxt, BeanDescription beanDesc) {
        return new BeanDeserializerBuilder(beanDesc, ctxt.getConfig());
    }

    protected void addBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        List<BeanPropertyDefinition> list;
        Object object;
        SettableBeanProperty[] settableBeanPropertyArray = beanDeserializerBuilder.getValueInstantiator().getFromObjectArguments(deserializationContext.getConfig());
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        boolean bl = false;
        Serializable serializable = annotationIntrospector.findIgnoreUnknownProperties(beanDescription.getClassInfo());
        if (serializable != null) {
            bl = (Boolean)serializable;
            beanDeserializerBuilder.setIgnoreUnknownProperties(bl);
        }
        serializable = ArrayBuilders.arrayToSet(annotationIntrospector.findPropertiesToIgnore(beanDescription.getClassInfo()));
        Object object2 = serializable.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            beanDeserializerBuilder.addIgnorable((String)object);
        }
        object2 = beanDescription.findAnySetter();
        if (object2 != null) {
            beanDeserializerBuilder.setAnySetter(this.constructAnySetter(deserializationContext, beanDescription, (AnnotatedMethod)object2));
        }
        if (object2 == null && (object = beanDescription.getIgnoredPropertyNames()) != null) {
            list = object.iterator();
            while (list.hasNext()) {
                Iterator<BeanDeserializerModifier> iterator = (String)list.next();
                beanDeserializerBuilder.addIgnorable((String)((Object)iterator));
            }
        }
        boolean bl2 = deserializationContext.isEnabled(MapperFeature.USE_GETTERS_AS_SETTERS) && deserializationContext.isEnabled(MapperFeature.AUTO_DETECT_GETTERS);
        list = this.filterBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder, beanDescription.findProperties(), (Set<String>)((Object)serializable));
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier object3 : this._factoryConfig.deserializerModifiers()) {
                list = object3.updateProperties(deserializationContext.getConfig(), beanDescription, list);
            }
        }
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            Object object3;
            Object object4;
            SettableBeanProperty settableBeanProperty = null;
            if (beanPropertyDefinition.hasConstructorParameter()) {
                object4 = beanPropertyDefinition.getName();
                object3 = settableBeanPropertyArray;
                int n = ((SettableBeanProperty[])object3).length;
                for (int i = 0; i < n; ++i) {
                    SettableBeanProperty settableBeanProperty2 = object3[i];
                    if (!((String)object4).equals(settableBeanProperty2.getName())) continue;
                    settableBeanProperty = settableBeanProperty2;
                    break;
                }
                if (settableBeanProperty == null) {
                    throw deserializationContext.mappingException("Could not find creator property with name '" + (String)object4 + "'");
                }
                beanDeserializerBuilder.addCreatorProperty(settableBeanProperty);
                continue;
            }
            if (beanPropertyDefinition.hasSetter()) {
                object4 = beanPropertyDefinition.getSetter().getGenericParameterType(0);
                settableBeanProperty = this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, (Type)object4);
            } else if (beanPropertyDefinition.hasField()) {
                object4 = beanPropertyDefinition.getField().getGenericType();
                settableBeanProperty = this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, (Type)object4);
            } else if (bl2 && beanPropertyDefinition.hasGetter() && (Collection.class.isAssignableFrom((Class<?>)(object3 = ((AnnotatedMethod)(object4 = beanPropertyDefinition.getGetter())).getRawType())) || Map.class.isAssignableFrom((Class<?>)object3))) {
                settableBeanProperty = this.constructSetterlessProperty(deserializationContext, beanDescription, beanPropertyDefinition);
            }
            if (settableBeanProperty == null) continue;
            object4 = beanPropertyDefinition.findViews();
            if (object4 == null && !deserializationContext.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                object4 = NO_VIEWS;
            }
            settableBeanProperty.setViews((Class<?>[])object4);
            beanDeserializerBuilder.addProperty(settableBeanProperty);
        }
    }

    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder, List<BeanPropertyDefinition> propDefsIn, Set<String> ignored) throws JsonMappingException {
        ArrayList<BeanPropertyDefinition> result = new ArrayList<BeanPropertyDefinition>(Math.max(4, propDefsIn.size()));
        HashMap ignoredTypes = new HashMap();
        for (BeanPropertyDefinition property : propDefsIn) {
            String name = property.getName();
            if (ignored.contains(name)) continue;
            if (!property.hasConstructorParameter()) {
                Class<?> rawPropertyType = null;
                if (property.hasSetter()) {
                    rawPropertyType = property.getSetter().getRawParameterType(0);
                } else if (property.hasField()) {
                    rawPropertyType = property.getField().getRawType();
                }
                if (rawPropertyType != null && this.isIgnorableType(ctxt.getConfig(), beanDesc, rawPropertyType, ignoredTypes)) {
                    builder.addIgnorable(name);
                    continue;
                }
            }
            result.add(property);
        }
        return result;
    }

    protected void addReferenceProperties(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        Map<String, AnnotatedMember> refs = beanDesc.findBackReferenceProperties();
        if (refs != null) {
            for (Map.Entry<String, AnnotatedMember> en : refs.entrySet()) {
                String name = en.getKey();
                AnnotatedMember m = en.getValue();
                Type genericType = m instanceof AnnotatedMethod ? ((AnnotatedMethod)m).getGenericParameterType(0) : m.getRawType();
                SimpleBeanPropertyDefinition propDef = new SimpleBeanPropertyDefinition(m);
                builder.addBackReferenceProperty(name, this.constructSettableProperty(ctxt, beanDesc, propDef, genericType));
            }
        }
    }

    protected void addInjectables(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        Map<Object, AnnotatedMember> raw = beanDesc.findInjectables();
        if (raw != null) {
            boolean fixAccess = ctxt.canOverrideAccessModifiers();
            for (Map.Entry<Object, AnnotatedMember> entry : raw.entrySet()) {
                AnnotatedMember m = entry.getValue();
                if (fixAccess) {
                    m.fixAccess();
                }
                builder.addInjectable(m.getName(), beanDesc.resolveType(m.getGenericType()), beanDesc.getClassAnnotations(), m, entry.getKey());
            }
        }
    }

    protected SettableAnyProperty constructAnySetter(DeserializationContext ctxt, BeanDescription beanDesc, AnnotatedMethod setter) throws JsonMappingException {
        if (ctxt.canOverrideAccessModifiers()) {
            setter.fixAccess();
        }
        JavaType type = beanDesc.bindingsForBeanType().resolveType(setter.getGenericParameterType(1));
        BeanProperty.Std property = new BeanProperty.Std(setter.getName(), type, beanDesc.getClassAnnotations(), setter);
        type = this.resolveType(ctxt, beanDesc, type, setter);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(ctxt, setter);
        if (deser != null) {
            return new SettableAnyProperty((BeanProperty)property, setter, type, deser);
        }
        type = this.modifyTypeByAnnotation(ctxt, setter, type);
        return new SettableAnyProperty((BeanProperty)property, setter, type, null);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationContext ctxt, BeanDescription beanDesc, BeanPropertyDefinition propDef, Type jdkType) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty ref;
        AnnotatedMember mutator = propDef.getMutator();
        if (ctxt.canOverrideAccessModifiers()) {
            mutator.fixAccess();
        }
        JavaType t0 = beanDesc.resolveType(jdkType);
        BeanProperty.Std property = new BeanProperty.Std(propDef.getName(), t0, beanDesc.getClassAnnotations(), mutator);
        JavaType type = this.resolveType(ctxt, beanDesc, t0, mutator);
        if (type != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(ctxt, mutator);
        type = this.modifyTypeByAnnotation(ctxt, mutator, type);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty prop = mutator instanceof AnnotatedMethod ? new MethodProperty(propDef, type, typeDeser, beanDesc.getClassAnnotations(), (AnnotatedMethod)mutator) : new FieldProperty(propDef, type, typeDeser, beanDesc.getClassAnnotations(), (AnnotatedField)mutator);
        if (propDeser != null) {
            prop = prop.withValueDeserializer(propDeser);
        }
        if ((ref = propDef.findReferenceType()) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationContext ctxt, BeanDescription beanDesc, BeanPropertyDefinition propDef) throws JsonMappingException {
        AnnotatedMethod getter = propDef.getGetter();
        if (ctxt.canOverrideAccessModifiers()) {
            getter.fixAccess();
        }
        JavaType type = getter.getType(beanDesc.bindingsForBeanType());
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(ctxt, getter);
        type = this.modifyTypeByAnnotation(ctxt, getter, type);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty prop = new SetterlessProperty(propDef, type, typeDeser, beanDesc.getClassAnnotations(), getter);
        if (propDeser != null) {
            prop = ((SettableBeanProperty)prop).withValueDeserializer(propDeser);
        }
        return prop;
    }

    protected boolean isPotentialBeanType(Class<?> clazz) {
        String string = ClassUtil.canBeABeanType(clazz);
        if (string != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + clazz.getName() + " (of type " + string + ") as a Bean");
        }
        if (ClassUtil.isProxyType(clazz)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + clazz.getName() + " as a Bean");
        }
        string = ClassUtil.isLocalType(clazz, true);
        if (string != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + clazz.getName() + " (of type " + string + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationConfig config, BeanDescription beanDesc, Class<?> type, Map<Class<?>, Boolean> ignoredTypes) {
        Boolean status = ignoredTypes.get(type);
        if (status == null) {
            BeanDescription desc = config.introspectClassAnnotations(type);
            status = config.getAnnotationIntrospector().isIgnorableType(desc.getClassInfo());
            if (status == null) {
                status = Boolean.FALSE;
            }
        }
        return status;
    }
}

