/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser;

import com.amazonaws.com.fasterxml.jackson.annotation.JsonFormat;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.JsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.KeyDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.NoClass;
import com.amazonaws.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.type.ArrayType;
import com.amazonaws.com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.amazonaws.com.fasterxml.jackson.databind.type.CollectionType;
import com.amazonaws.com.fasterxml.jackson.databind.type.MapLikeType;
import com.amazonaws.com.fasterxml.jackson.databind.type.MapType;
import com.amazonaws.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class DeserializerCache
implements Serializable {
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);

    public JsonDeserializer<Object> findValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType propertyType) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(propertyType);
        if (deser != null) {
            return deser;
        }
        deser = this._createAndCacheValueDeserializer(ctxt, factory, propertyType);
        if (deser == null) {
            deser = this._handleUnknownValueDeserializer(propertyType);
        }
        return deser;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) throws JsonMappingException {
        KeyDeserializer kd = factory.createKeyDeserializer(ctxt, type);
        if (kd == null) {
            return this._handleUnknownKeyDeserializer(type);
        }
        if (kd instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)kd)).resolve(ctxt);
        }
        return kd;
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null JavaType passed");
        }
        return this._cachedDeserializers.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            JsonDeserializer<Object> jsonDeserializer;
            block9: {
                JsonDeserializer<Object> deser = this._findCachedDeserializer(type);
                if (deser != null) {
                    return deser;
                }
                int count = this._incompleteDeserializers.size();
                if (count > 0 && (deser = this._incompleteDeserializers.get(type)) != null) {
                    return deser;
                }
                try {
                    jsonDeserializer = this._createAndCache2(ctxt, factory, type);
                    if (count != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable) {
                    if (count == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable;
                }
            }
            return jsonDeserializer;
        }
    }

    protected JsonDeserializer<Object> _createAndCache2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        try {
            deser = this._createDeserializer(ctxt, factory, type);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (deser == null) {
            return null;
        }
        boolean isResolvable = deser instanceof ResolvableDeserializer;
        boolean addToCache = deser.isCachable();
        if (isResolvable) {
            this._incompleteDeserializers.put(type, deser);
            ((ResolvableDeserializer)((Object)deser)).resolve(ctxt);
            this._incompleteDeserializers.remove(type);
        }
        if (addToCache) {
            this._cachedDeserializers.put(type, deser);
        }
        return deser;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) throws JsonMappingException {
        Class<?> clazz;
        Object t;
        JsonDeserializer<Object> jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (javaType.isAbstract() || javaType.isMapLikeType() || javaType.isCollectionLikeType()) {
            javaType = deserializerFactory.mapAbstractType(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, ((BeanDescription)(t = deserializationConfig.introspect(javaType))).getClassInfo())) != null) {
            return jsonDeserializer;
        }
        JavaType javaType2 = this.modifyTypeByAnnotation(deserializationContext, ((BeanDescription)t).getClassInfo(), javaType);
        if (javaType2 != javaType) {
            javaType = javaType2;
            t = deserializationConfig.introspect(javaType2);
        }
        if ((clazz = ((BeanDescription)t).findPOJOBuilder()) != null) {
            return deserializerFactory.createBuilderBasedDeserializer(deserializationContext, javaType, (BeanDescription)t, clazz);
        }
        if (javaType.isEnumType()) {
            return deserializerFactory.createEnumDeserializer(deserializationContext, javaType, (BeanDescription)t);
        }
        if (javaType.isContainerType()) {
            JsonFormat.Value value;
            if (javaType.isArrayType()) {
                return deserializerFactory.createArrayDeserializer(deserializationContext, (ArrayType)javaType, (BeanDescription)t);
            }
            if (javaType.isMapLikeType()) {
                MapLikeType mapLikeType = (MapLikeType)javaType;
                if (mapLikeType.isTrueMapType()) {
                    return deserializerFactory.createMapDeserializer(deserializationContext, (MapType)mapLikeType, (BeanDescription)t);
                }
                return deserializerFactory.createMapLikeDeserializer(deserializationContext, mapLikeType, (BeanDescription)t);
            }
            if (javaType.isCollectionLikeType() && ((value = ((BeanDescription)t).findExpectedFormat(null)) == null || value.getShape() != JsonFormat.Shape.OBJECT)) {
                CollectionLikeType collectionLikeType = (CollectionLikeType)javaType;
                if (collectionLikeType.isTrueCollectionType()) {
                    return deserializerFactory.createCollectionDeserializer(deserializationContext, (CollectionType)collectionLikeType, (BeanDescription)t);
                }
                return deserializerFactory.createCollectionLikeDeserializer(deserializationContext, collectionLikeType, (BeanDescription)t);
            }
        }
        if (JsonNode.class.isAssignableFrom(javaType.getRawClass())) {
            return deserializerFactory.createTreeDeserializer(deserializationConfig, javaType, (BeanDescription)t);
        }
        return deserializerFactory.createBeanDeserializer(deserializationContext, javaType, (BeanDescription)t);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) throws JsonMappingException {
        Object deserDef = ctxt.getAnnotationIntrospector().findDeserializer(ann);
        if (deserDef == null) {
            return null;
        }
        return ctxt.deserializerInstance(ann, deserDef);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        Class<?> clazz = annotationIntrospector.findDeserializationType(annotated, javaType);
        if (clazz != null) {
            try {
                javaType = javaType.narrowBy(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonMappingException("Failed to narrow type " + javaType + " with concrete-type annotation (value " + clazz.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage(), null, illegalArgumentException);
            }
        }
        if (javaType.isContainerType()) {
            Object object;
            Object object2;
            Object object3;
            JavaType javaType2;
            Class<?> clazz2 = annotationIntrospector.findDeserializationKeyType(annotated, javaType.getKeyType());
            if (clazz2 != null) {
                if (!(javaType instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + javaType + " is not a Map(-like) type");
                }
                try {
                    javaType = ((MapLikeType)javaType).narrowKey(clazz2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow key type " + javaType + " with key-type annotation (" + clazz2.getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if ((javaType2 = javaType.getKeyType()) != null && javaType2.getValueHandler() == null && (object3 = annotationIntrospector.findKeyDeserializer(annotated)) != null && (object2 = deserializationContext.keyDeserializerInstance(annotated, object3)) != null) {
                javaType = ((MapLikeType)javaType).withKeyValueHandler(object2);
                javaType2 = javaType.getKeyType();
            }
            if ((object3 = annotationIntrospector.findDeserializationContentType(annotated, javaType.getContentType())) != null) {
                try {
                    javaType = javaType.narrowContentsBy((Class<?>)object3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow content type " + javaType + " with content-type annotation (" + ((Class)object3).getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if (((JavaType)(object2 = javaType.getContentType())).getValueHandler() == null && (object = annotationIntrospector.findContentDeserializer(annotated)) != null) {
                JsonDeserializer<Object> jsonDeserializer = null;
                if (object instanceof JsonDeserializer) {
                    object = (JsonDeserializer)object;
                } else {
                    Class<?> clazz3 = this._verifyAsClass(object, "findContentDeserializer", JsonDeserializer.None.class);
                    if (clazz3 != null) {
                        jsonDeserializer = deserializationContext.deserializerInstance(annotated, clazz3);
                    }
                }
                if (jsonDeserializer != null) {
                    javaType = javaType.withContentValueHandler(jsonDeserializer);
                }
            }
        }
        return javaType;
    }

    private Class<?> _verifyAsClass(Object object, String string, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == clazz || clazz2 == NoClass.class) {
            return null;
        }
        return clazz2;
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType javaType) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (!ClassUtil.isConcrete(clazz)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + javaType);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + javaType);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType javaType) throws JsonMappingException {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + javaType);
    }
}

