/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.node;

import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.databind.JsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.ContainerNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode> {
    protected List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory nc) {
        super(nc);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children == null ? ContainerNode.NoNodesIterator.instance() : this._children.iterator();
    }

    @Override
    public JsonNode get(String fieldName) {
        return null;
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeStartArray();
        if (this._children != null) {
            for (JsonNode n : this._children) {
                ((BaseJsonNode)n).serialize(jg, provider);
            }
        }
        jg.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jg, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForArray(this, jg);
        if (this._children != null) {
            for (JsonNode n : this._children) {
                ((BaseJsonNode)n).serialize(jg, provider);
            }
        }
        typeSer.writeTypeSuffixForArray(this, jg);
    }

    public ArrayNode add(JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._add(value);
        return this;
    }

    protected List<JsonNode> _createList() {
        return new ArrayList<JsonNode>();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        if (this._children == null || this._children.size() == 0) {
            return other.size() == 0;
        }
        return other._sameChildren(this._children);
    }

    public int hashCode() {
        int hash;
        if (this._children == null) {
            hash = 1;
        } else {
            hash = this._children.size();
            for (JsonNode n : this._children) {
                if (n == null) continue;
                hash ^= n.hashCode();
            }
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16 + (this.size() << 4));
        sb.append('[');
        if (this._children != null) {
            int len = this._children.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this._children.get(i).toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private ArrayNode _add(JsonNode node) {
        if (this._children == null) {
            this._children = this._createList();
        }
        this._children.add(node);
        return this;
    }

    private boolean _sameChildren(List<JsonNode> otherChildren) {
        int len = otherChildren.size();
        if (this.size() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this._children.get(i).equals(otherChildren.get(i))) continue;
            return false;
        }
        return true;
    }
}

