/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.type;

import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializable;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;

public abstract class TypeBase
extends JavaType
implements JsonSerializable {
    volatile transient String _canonicalName;

    protected TypeBase(Class<?> raw, int hash, Object valueHandler, Object typeHandler) {
        super(raw, hash, valueHandler, typeHandler);
    }

    @Override
    public String toCanonical() {
        String str = this._canonicalName;
        if (str == null) {
            str = this.buildCanonicalName();
        }
        return str;
    }

    protected abstract String buildCanonicalName();

    @Override
    public <T> T getValueHandler() {
        return (T)this._valueHandler;
    }

    @Override
    public <T> T getTypeHandler() {
        return (T)this._typeHandler;
    }

    @Override
    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForScalar(this, jgen);
        this.serialize(jgen, provider);
        typeSer.writeTypeSuffixForScalar(this, jgen);
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeString(this.toCanonical());
    }
}

