/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn;

import com.amazonaws.http.conn.ClientConnectionRequestFactory;
import com.amazonaws.http.conn.Wrapped;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.conn.ClientConnectionManager;
import com.amazonaws.org.apache.http.conn.ClientConnectionRequest;
import com.amazonaws.org.apache.http.pool.ConnPoolControl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ClientConnectionManagerFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionManagerFactory.class);

    public static ClientConnectionManager wrap(ClientConnectionManager orig) {
        if (orig instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        Class[] interfaces = orig instanceof ConnPoolControl ? new Class[]{ClientConnectionManager.class, ConnPoolControl.class, Wrapped.class} : new Class[]{ClientConnectionManager.class, Wrapped.class};
        return (ClientConnectionManager)Proxy.newProxyInstance(ClientConnectionManagerFactory.class.getClassLoader(), interfaces, (InvocationHandler)new Handler(orig));
    }

    private static class Handler
    implements InvocationHandler {
        private final ClientConnectionManager orig;

        Handler(ClientConnectionManager real) {
            this.orig = real;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object ret = method.invoke((Object)this.orig, args);
                return ret instanceof ClientConnectionRequest ? ClientConnectionRequestFactory.wrap((ClientConnectionRequest)ret) : ret;
            }
            catch (InvocationTargetException e) {
                log.debug("", e);
                throw e.getCause();
            }
        }
    }
}

