/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.conn.scheme;

import com.amazonaws.org.apache.http.HttpHost;
import com.amazonaws.org.apache.http.conn.scheme.Scheme;
import java.util.concurrent.ConcurrentHashMap;

public final class SchemeRegistry {
    private final ConcurrentHashMap<String, Scheme> registeredSchemes = new ConcurrentHashMap();

    public final Scheme getScheme(String name) {
        Scheme found = this.get(name);
        if (found == null) {
            throw new IllegalStateException("Scheme '" + name + "' not registered.");
        }
        return found;
    }

    public final Scheme getScheme(HttpHost host) {
        if (host == null) {
            throw new IllegalArgumentException("Host must not be null.");
        }
        return this.getScheme(host.getSchemeName());
    }

    public final Scheme get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme found = this.registeredSchemes.get(name);
        return found;
    }

    public final Scheme register(Scheme sch) {
        if (sch == null) {
            throw new IllegalArgumentException("Scheme must not be null.");
        }
        Scheme old = this.registeredSchemes.put(sch.getName(), sch);
        return old;
    }
}

