/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.impl.client;

import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.ConnectionReuseStrategy;
import com.amazonaws.org.apache.http.HttpEntity;
import com.amazonaws.org.apache.http.HttpEntityEnclosingRequest;
import com.amazonaws.org.apache.http.HttpException;
import com.amazonaws.org.apache.http.HttpHost;
import com.amazonaws.org.apache.http.HttpRequest;
import com.amazonaws.org.apache.http.HttpResponse;
import com.amazonaws.org.apache.http.ProtocolException;
import com.amazonaws.org.apache.http.ProtocolVersion;
import com.amazonaws.org.apache.http.auth.AuthProtocolState;
import com.amazonaws.org.apache.http.auth.AuthState;
import com.amazonaws.org.apache.http.auth.UsernamePasswordCredentials;
import com.amazonaws.org.apache.http.client.AuthenticationHandler;
import com.amazonaws.org.apache.http.client.AuthenticationStrategy;
import com.amazonaws.org.apache.http.client.HttpRequestRetryHandler;
import com.amazonaws.org.apache.http.client.NonRepeatableRequestException;
import com.amazonaws.org.apache.http.client.RedirectException;
import com.amazonaws.org.apache.http.client.RedirectHandler;
import com.amazonaws.org.apache.http.client.RedirectStrategy;
import com.amazonaws.org.apache.http.client.RequestDirector;
import com.amazonaws.org.apache.http.client.UserTokenHandler;
import com.amazonaws.org.apache.http.client.methods.AbortableHttpRequest;
import com.amazonaws.org.apache.http.client.params.HttpClientParams;
import com.amazonaws.org.apache.http.client.utils.URIUtils;
import com.amazonaws.org.apache.http.conn.BasicManagedEntity;
import com.amazonaws.org.apache.http.conn.ClientConnectionManager;
import com.amazonaws.org.apache.http.conn.ClientConnectionRequest;
import com.amazonaws.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.amazonaws.org.apache.http.conn.ManagedClientConnection;
import com.amazonaws.org.apache.http.conn.routing.BasicRouteDirector;
import com.amazonaws.org.apache.http.conn.routing.HttpRoute;
import com.amazonaws.org.apache.http.conn.routing.HttpRoutePlanner;
import com.amazonaws.org.apache.http.conn.scheme.Scheme;
import com.amazonaws.org.apache.http.entity.BufferedHttpEntity;
import com.amazonaws.org.apache.http.impl.auth.BasicScheme;
import com.amazonaws.org.apache.http.impl.client.AuthenticationStrategyAdaptor;
import com.amazonaws.org.apache.http.impl.client.DefaultRedirectStrategyAdaptor;
import com.amazonaws.org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import com.amazonaws.org.apache.http.impl.client.HttpAuthenticator;
import com.amazonaws.org.apache.http.impl.client.RequestWrapper;
import com.amazonaws.org.apache.http.impl.client.RoutedRequest;
import com.amazonaws.org.apache.http.impl.client.TunnelRefusedException;
import com.amazonaws.org.apache.http.impl.conn.ConnectionShutdownException;
import com.amazonaws.org.apache.http.message.AbstractHttpMessage;
import com.amazonaws.org.apache.http.message.BasicHttpRequest;
import com.amazonaws.org.apache.http.params.HttpConnectionParams;
import com.amazonaws.org.apache.http.params.HttpParams;
import com.amazonaws.org.apache.http.params.HttpProtocolParams;
import com.amazonaws.org.apache.http.protocol.HttpContext;
import com.amazonaws.org.apache.http.protocol.HttpProcessor;
import com.amazonaws.org.apache.http.protocol.HttpRequestExecutor;
import com.amazonaws.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

public class DefaultRequestDirector
implements RequestDirector {
    private final Log log;
    protected final ClientConnectionManager connManager;
    protected final HttpRoutePlanner routePlanner;
    protected final ConnectionReuseStrategy reuseStrategy;
    protected final ConnectionKeepAliveStrategy keepAliveStrategy;
    protected final HttpRequestExecutor requestExec;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestRetryHandler retryHandler;
    @Deprecated
    protected final RedirectHandler redirectHandler;
    protected final RedirectStrategy redirectStrategy;
    @Deprecated
    protected final AuthenticationHandler targetAuthHandler;
    protected final AuthenticationStrategy targetAuthStrategy;
    @Deprecated
    protected final AuthenticationHandler proxyAuthHandler;
    protected final AuthenticationStrategy proxyAuthStrategy;
    protected final UserTokenHandler userTokenHandler;
    protected final HttpParams params;
    protected ManagedClientConnection managedConn;
    protected final AuthState targetAuthState;
    protected final AuthState proxyAuthState;
    private final HttpAuthenticator authenticator;
    private int execCount;
    private int redirectCount;
    private int maxRedirects;
    private HttpHost virtualHost;

    @Deprecated
    public DefaultRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        this(LogFactory.getLog(DefaultRequestDirector.class), requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, (RedirectStrategy)new DefaultRedirectStrategyAdaptor(redirectHandler), new AuthenticationStrategyAdaptor(targetAuthHandler), new AuthenticationStrategyAdaptor(proxyAuthHandler), userTokenHandler, params);
    }

    @Deprecated
    public DefaultRequestDirector(Log log, HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        this(LogFactory.getLog(DefaultRequestDirector.class), requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, new AuthenticationStrategyAdaptor(targetAuthHandler), new AuthenticationStrategyAdaptor(proxyAuthHandler), userTokenHandler, params);
    }

    public DefaultRequestDirector(Log log, HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler, HttpParams params) {
        if (log == null) {
            throw new IllegalArgumentException("Log may not be null.");
        }
        if (requestExec == null) {
            throw new IllegalArgumentException("Request executor may not be null.");
        }
        if (conman == null) {
            throw new IllegalArgumentException("Client connection manager may not be null.");
        }
        if (reustrat == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null.");
        }
        if (kastrat == null) {
            throw new IllegalArgumentException("Connection keep alive strategy may not be null.");
        }
        if (rouplan == null) {
            throw new IllegalArgumentException("Route planner may not be null.");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP protocol processor may not be null.");
        }
        if (retryHandler == null) {
            throw new IllegalArgumentException("HTTP request retry handler may not be null.");
        }
        if (redirectStrategy == null) {
            throw new IllegalArgumentException("Redirect strategy may not be null.");
        }
        if (targetAuthStrategy == null) {
            throw new IllegalArgumentException("Target authentication strategy may not be null.");
        }
        if (proxyAuthStrategy == null) {
            throw new IllegalArgumentException("Proxy authentication strategy may not be null.");
        }
        if (userTokenHandler == null) {
            throw new IllegalArgumentException("User token handler may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.log = log;
        this.authenticator = new HttpAuthenticator(log);
        this.requestExec = requestExec;
        this.connManager = conman;
        this.reuseStrategy = reustrat;
        this.keepAliveStrategy = kastrat;
        this.routePlanner = rouplan;
        this.httpProcessor = httpProcessor;
        this.retryHandler = retryHandler;
        this.redirectStrategy = redirectStrategy;
        this.targetAuthStrategy = targetAuthStrategy;
        this.proxyAuthStrategy = proxyAuthStrategy;
        this.userTokenHandler = userTokenHandler;
        this.params = params;
        this.redirectHandler = redirectStrategy instanceof DefaultRedirectStrategyAdaptor ? ((DefaultRedirectStrategyAdaptor)redirectStrategy).getHandler() : null;
        this.targetAuthHandler = targetAuthStrategy instanceof AuthenticationStrategyAdaptor ? ((AuthenticationStrategyAdaptor)targetAuthStrategy).getHandler() : null;
        this.proxyAuthHandler = proxyAuthStrategy instanceof AuthenticationStrategyAdaptor ? ((AuthenticationStrategyAdaptor)proxyAuthStrategy).getHandler() : null;
        this.managedConn = null;
        this.execCount = 0;
        this.redirectCount = 0;
        this.targetAuthState = new AuthState();
        this.proxyAuthState = new AuthState();
        this.maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
    }

    private RequestWrapper wrapRequest(HttpRequest request) throws ProtocolException {
        if (request instanceof HttpEntityEnclosingRequest) {
            return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
        }
        return new RequestWrapper(request);
    }

    protected void rewriteRequestURI(RequestWrapper request, HttpRoute route) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (route.getProxyHost() != null && !route.isTunnelled()) {
                if (!uri.isAbsolute()) {
                    HttpHost target = route.getTargetHost();
                    uri = URIUtils.rewriteURI(uri, target, true);
                } else {
                    uri = URIUtils.rewriteURI(uri);
                }
            } else {
                uri = uri.isAbsolute() ? URIUtils.rewriteURI(uri, null, true) : URIUtils.rewriteURI(uri);
            }
            request.setURI(uri);
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), ex);
        }
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Object object;
        boolean bl;
        httpContext.setAttribute("http.auth.target-scope", this.targetAuthState);
        httpContext.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
        HttpRequest httpRequest2 = httpRequest;
        RequestWrapper requestWrapper = this.wrapRequest(httpRequest2);
        requestWrapper.setParams(this.params);
        HttpRoute httpRoute = this.determineRoute(httpHost, requestWrapper, httpContext);
        this.virtualHost = (HttpHost)requestWrapper.getParams().getParameter("http.virtual-host");
        if (this.virtualHost != null && this.virtualHost.getPort() == -1 && !(bl = ((HttpHost)(object = httpHost != null ? httpHost : httpRoute.getTargetHost())).getPort())) {
            this.virtualHost = new HttpHost(this.virtualHost.getHostName(), bl ? 1 : 0, this.virtualHost.getSchemeName());
        }
        object = new RoutedRequest(requestWrapper, httpRoute);
        bl = false;
        boolean bl2 = false;
        try {
            Object object2;
            HttpResponse httpResponse = null;
            while (!bl2) {
                Object object3;
                Object object4;
                Object object5;
                object2 = ((RoutedRequest)object).getRequest();
                HttpRoute httpRoute2 = ((RoutedRequest)object).getRoute();
                httpResponse = null;
                Object object6 = httpContext.getAttribute("http.user-token");
                if (this.managedConn == null) {
                    object5 = this.connManager.requestConnection(httpRoute2, object6);
                    if (httpRequest2 instanceof AbortableHttpRequest) {
                        ((AbortableHttpRequest)((Object)httpRequest2)).setConnectionRequest((ClientConnectionRequest)object5);
                    }
                    long l = HttpClientParams.getConnectionManagerTimeout(this.params);
                    try {
                        this.managedConn = object5.getConnection(l, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        object4 = new InterruptedIOException();
                        ((Throwable)object4).initCause(interruptedException);
                        throw object4;
                    }
                    if (HttpConnectionParams.isStaleCheckingEnabled(this.params) && this.managedConn.isOpen()) {
                        this.log.debug("Stale connection check");
                        if (this.managedConn.isStale()) {
                            this.log.debug("Stale connection detected");
                            this.managedConn.close();
                        }
                    }
                }
                if (httpRequest2 instanceof AbortableHttpRequest) {
                    ((AbortableHttpRequest)((Object)httpRequest2)).setReleaseTrigger(this.managedConn);
                }
                try {
                    this.tryConnect((RoutedRequest)object, httpContext);
                }
                catch (TunnelRefusedException tunnelRefusedException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(tunnelRefusedException.getMessage());
                    }
                    httpResponse = tunnelRefusedException.getResponse();
                    break;
                }
                object5 = ((RequestWrapper)object2).getURI().getUserInfo();
                if (object5 != null) {
                    this.targetAuthState.update(new BasicScheme(), new UsernamePasswordCredentials((String)object5));
                }
                HttpHost httpHost2 = httpRoute2.getProxyHost();
                if (this.virtualHost != null) {
                    httpHost = this.virtualHost;
                } else {
                    object3 = ((RequestWrapper)object2).getURI();
                    if (((URI)object3).isAbsolute()) {
                        httpHost = new HttpHost(((URI)object3).getHost(), ((URI)object3).getPort(), ((URI)object3).getScheme());
                    }
                }
                if (httpHost == null) {
                    httpHost = httpRoute2.getTargetHost();
                }
                ((RequestWrapper)object2).resetHeaders();
                this.rewriteRequestURI((RequestWrapper)object2, httpRoute2);
                httpContext.setAttribute("http.target_host", httpHost);
                httpContext.setAttribute("http.proxy_host", httpHost2);
                httpContext.setAttribute("http.connection", this.managedConn);
                this.requestExec.preProcess((HttpRequest)object2, this.httpProcessor, httpContext);
                httpResponse = this.tryExecute((RoutedRequest)object, httpContext);
                if (httpResponse == null) continue;
                httpResponse.setParams(this.params);
                this.requestExec.postProcess(httpResponse, this.httpProcessor, httpContext);
                bl = this.reuseStrategy.keepAlive(httpResponse, httpContext);
                if (bl) {
                    long l = this.keepAliveStrategy.getKeepAliveDuration(httpResponse, httpContext);
                    if (this.log.isDebugEnabled()) {
                        object4 = l > 0L ? "for " + l + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                        this.log.debug("Connection can be kept alive " + (String)object4);
                    }
                    this.managedConn.setIdleDuration(l, TimeUnit.MILLISECONDS);
                }
                if ((object3 = this.handleResponse((RoutedRequest)object, httpResponse, httpContext)) == null) {
                    bl2 = true;
                } else {
                    if (bl) {
                        HttpEntity httpEntity = httpResponse.getEntity();
                        EntityUtils.consume(httpEntity);
                        this.managedConn.markReusable();
                    } else {
                        this.managedConn.close();
                        if (this.proxyAuthState.getState().compareTo(AuthProtocolState.CHALLENGED) > 0 && this.proxyAuthState.getAuthScheme() != null && this.proxyAuthState.getAuthScheme().isConnectionBased()) {
                            this.log.debug("Resetting proxy auth state");
                            this.proxyAuthState.reset();
                        }
                        if (this.targetAuthState.getState().compareTo(AuthProtocolState.CHALLENGED) > 0 && this.targetAuthState.getAuthScheme() != null && this.targetAuthState.getAuthScheme().isConnectionBased()) {
                            this.log.debug("Resetting target auth state");
                            this.targetAuthState.reset();
                        }
                    }
                    if (!((RoutedRequest)object3).getRoute().equals(((RoutedRequest)object).getRoute())) {
                        this.releaseConnection();
                    }
                    object = object3;
                }
                if (this.managedConn == null) continue;
                if (object6 == null) {
                    object6 = this.userTokenHandler.getUserToken(httpContext);
                    httpContext.setAttribute("http.user-token", object6);
                }
                if (object6 == null) continue;
                this.managedConn.setState(object6);
            }
            if (httpResponse == null || httpResponse.getEntity() == null || !httpResponse.getEntity().isStreaming()) {
                if (bl) {
                    this.managedConn.markReusable();
                }
                this.releaseConnection();
            } else {
                object2 = httpResponse.getEntity();
                object2 = new BasicManagedEntity((HttpEntity)object2, this.managedConn, bl);
                httpResponse.setEntity((HttpEntity)object2);
            }
            return httpResponse;
        }
        catch (ConnectionShutdownException connectionShutdownException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("Connection has been shut down");
            interruptedIOException.initCause(connectionShutdownException);
            throw interruptedIOException;
        }
        catch (HttpException httpException) {
            this.abortConnection();
            throw httpException;
        }
        catch (IOException iOException) {
            this.abortConnection();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortConnection();
            throw runtimeException;
        }
    }

    private void tryConnect(RoutedRequest routedRequest, HttpContext httpContext) throws HttpException, IOException {
        HttpRoute httpRoute = routedRequest.getRoute();
        RequestWrapper requestWrapper = routedRequest.getRequest();
        int n = 0;
        while (true) {
            httpContext.setAttribute("http.request", requestWrapper);
            ++n;
            try {
                if (!this.managedConn.isOpen()) {
                    this.managedConn.open(httpRoute, httpContext, this.params);
                } else {
                    this.managedConn.setSocketTimeout(HttpConnectionParams.getSoTimeout(this.params));
                }
                this.establishRoute(httpRoute, httpContext);
            }
            catch (IOException iOException) {
                try {
                    this.managedConn.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                if (this.retryHandler.retryRequest(iOException, n, httpContext)) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("I/O exception (" + iOException.getClass().getName() + ") caught when connecting to the target host: " + iOException.getMessage());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(iOException.getMessage(), iOException);
                    }
                    this.log.info("Retrying connect");
                    continue;
                }
                throw iOException;
            }
            break;
        }
    }

    private HttpResponse tryExecute(RoutedRequest routedRequest, HttpContext httpContext) throws HttpException, IOException {
        RequestWrapper requestWrapper = routedRequest.getRequest();
        HttpRoute httpRoute = routedRequest.getRoute();
        HttpResponse httpResponse = null;
        IOException iOException = null;
        while (true) {
            ++this.execCount;
            requestWrapper.incrementExecCount();
            if (!requestWrapper.isRepeatable()) {
                this.log.debug("Cannot retry non-repeatable request");
                if (iOException != null) {
                    throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.  The cause lists the reason the original request failed.", iOException);
                }
                throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
            }
            try {
                if (!this.managedConn.isOpen()) {
                    if (!httpRoute.isTunnelled()) {
                        this.log.debug("Reopening the direct connection.");
                        this.managedConn.open(httpRoute, httpContext, this.params);
                    } else {
                        this.log.debug("Proxied connection. Need to start over.");
                        break;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Attempt " + this.execCount + " to execute request");
                }
                httpResponse = this.requestExec.execute(requestWrapper, this.managedConn, httpContext);
            }
            catch (IOException iOException2) {
                this.log.debug("Closing the connection.");
                try {
                    this.managedConn.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                if (this.retryHandler.retryRequest(iOException2, requestWrapper.getExecCount(), httpContext)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("I/O exception (" + iOException2.getClass().getName() + ") caught when processing request: " + iOException2.getMessage());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(iOException2.getMessage(), iOException2);
                    }
                    this.log.info("Retrying request");
                    iOException = iOException2;
                    continue;
                }
                throw iOException2;
            }
            break;
        }
        return httpResponse;
    }

    protected void releaseConnection() {
        try {
            this.managedConn.releaseConnection();
        }
        catch (IOException iOException) {
            this.log.debug("IOException releasing connection", iOException);
        }
        this.managedConn = null;
    }

    protected HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        if (httpHost == null) {
            httpHost = (HttpHost)httpRequest.getParams().getParameter("http.default-host");
        }
        if (httpHost == null) {
            throw new IllegalStateException("Target host must not be null, or set in parameters.");
        }
        return this.routePlanner.determineRoute(httpHost, httpRequest, httpContext);
    }

    protected void establishRoute(HttpRoute httpRoute, HttpContext httpContext) throws HttpException, IOException {
        int n;
        BasicRouteDirector basicRouteDirector = new BasicRouteDirector();
        do {
            HttpRoute httpRoute2 = this.managedConn.getRoute();
            n = basicRouteDirector.nextStep(httpRoute, httpRoute2);
            switch (n) {
                case 1: 
                case 2: {
                    this.managedConn.open(httpRoute, httpContext, this.params);
                    break;
                }
                case 3: {
                    int n2 = this.createTunnelToTarget(httpRoute, httpContext);
                    this.log.debug("Tunnel to target created.");
                    this.managedConn.tunnelTarget(n2 != 0, this.params);
                    break;
                }
                case 4: {
                    int n2 = httpRoute2.getHopCount() - 1;
                    boolean bl = this.createTunnelToProxy(httpRoute, n2, httpContext);
                    this.log.debug("Tunnel to proxy created.");
                    this.managedConn.tunnelProxy(httpRoute.getHopTarget(n2), bl, this.params);
                    break;
                }
                case 5: {
                    this.managedConn.layerProtocol(httpContext, this.params);
                    break;
                }
                case -1: {
                    throw new HttpException("Unable to establish route: planned = " + httpRoute + "; current = " + httpRoute2);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + n + " from RouteDirector.");
                }
            }
        } while (n > 0);
    }

    protected boolean createTunnelToTarget(HttpRoute httpRoute, HttpContext httpContext) throws HttpException, IOException {
        HttpHost httpHost = httpRoute.getProxyHost();
        HttpHost httpHost2 = httpRoute.getTargetHost();
        HttpResponse httpResponse = null;
        while (true) {
            if (!this.managedConn.isOpen()) {
                this.managedConn.open(httpRoute, httpContext, this.params);
            }
            HttpRequest httpRequest = this.createConnectRequest(httpRoute, httpContext);
            httpRequest.setParams(this.params);
            httpContext.setAttribute("http.target_host", httpHost2);
            httpContext.setAttribute("http.proxy_host", httpHost);
            httpContext.setAttribute("http.connection", this.managedConn);
            httpContext.setAttribute("http.request", httpRequest);
            this.requestExec.preProcess(httpRequest, this.httpProcessor, httpContext);
            httpResponse = this.requestExec.execute(httpRequest, this.managedConn, httpContext);
            httpResponse.setParams(this.params);
            this.requestExec.postProcess(httpResponse, this.httpProcessor, httpContext);
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + httpResponse.getStatusLine());
            }
            if (!HttpClientParams.isAuthenticating(this.params)) continue;
            if (!this.authenticator.isAuthenticationRequested(httpHost, httpResponse, this.proxyAuthStrategy, this.proxyAuthState, httpContext) || !this.authenticator.authenticate(httpHost, httpResponse, this.proxyAuthStrategy, this.proxyAuthState, httpContext)) break;
            if (this.reuseStrategy.keepAlive(httpResponse, httpContext)) {
                this.log.debug("Connection kept alive");
                HttpEntity httpEntity = httpResponse.getEntity();
                EntityUtils.consume(httpEntity);
                continue;
            }
            this.managedConn.close();
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n > 299) {
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                httpResponse.setEntity(new BufferedHttpEntity(httpEntity));
            }
            this.managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + httpResponse.getStatusLine(), httpResponse);
        }
        this.managedConn.markReusable();
        return false;
    }

    protected boolean createTunnelToProxy(HttpRoute httpRoute, int n, HttpContext httpContext) throws HttpException, IOException {
        throw new HttpException("Proxy chains are not supported.");
    }

    protected HttpRequest createConnectRequest(HttpRoute httpRoute, HttpContext httpContext) {
        Object object;
        HttpHost httpHost = httpRoute.getTargetHost();
        String string = httpHost.getHostName();
        int n = httpHost.getPort();
        if (n < 0) {
            object = this.connManager.getSchemeRegistry().getScheme(httpHost.getSchemeName());
            n = ((Scheme)object).getDefaultPort();
        }
        object = new StringBuilder(string.length() + 6);
        ((StringBuilder)object).append(string);
        ((StringBuilder)object).append(':');
        ((StringBuilder)object).append(Integer.toString(n));
        String string2 = ((StringBuilder)object).toString();
        ProtocolVersion protocolVersion = HttpProtocolParams.getVersion(this.params);
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest("CONNECT", string2, protocolVersion);
        return basicHttpRequest;
    }

    protected RoutedRequest handleResponse(RoutedRequest routedRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Object object;
        Object object2;
        HttpRoute httpRoute = routedRequest.getRoute();
        RequestWrapper requestWrapper = routedRequest.getRequest();
        HttpParams httpParams = requestWrapper.getParams();
        if (HttpClientParams.isAuthenticating(httpParams)) {
            object2 = (HttpHost)httpContext.getAttribute("http.target_host");
            if (object2 == null) {
                object2 = httpRoute.getTargetHost();
            }
            if (((HttpHost)object2).getPort() < 0) {
                object = this.connManager.getSchemeRegistry().getScheme((HttpHost)object2);
                object2 = new HttpHost(((HttpHost)object2).getHostName(), ((Scheme)object).getDefaultPort(), ((HttpHost)object2).getSchemeName());
            }
            if (this.authenticator.isAuthenticationRequested((HttpHost)object2, httpResponse, this.targetAuthStrategy, this.targetAuthState, httpContext) && this.authenticator.authenticate((HttpHost)object2, httpResponse, this.targetAuthStrategy, this.targetAuthState, httpContext)) {
                return routedRequest;
            }
            object = httpRoute.getProxyHost();
            if (this.authenticator.isAuthenticationRequested((HttpHost)object, httpResponse, this.proxyAuthStrategy, this.proxyAuthState, httpContext)) {
                if (object == null) {
                    object = httpRoute.getTargetHost();
                }
                if (this.authenticator.authenticate((HttpHost)object, httpResponse, this.proxyAuthStrategy, this.proxyAuthState, httpContext)) {
                    return routedRequest;
                }
            }
        }
        if (HttpClientParams.isRedirecting(httpParams) && this.redirectStrategy.isRedirected(requestWrapper, httpResponse, httpContext)) {
            Object object3;
            if (this.redirectCount >= this.maxRedirects) {
                throw new RedirectException("Maximum redirects (" + this.maxRedirects + ") exceeded");
            }
            ++this.redirectCount;
            this.virtualHost = null;
            object2 = this.redirectStrategy.getRedirect(requestWrapper, httpResponse, httpContext);
            object = requestWrapper.getOriginal();
            object2.setHeaders(object.getAllHeaders());
            URI uRI = object2.getURI();
            HttpHost httpHost = URIUtils.extractHost(uRI);
            if (httpHost == null) {
                throw new ProtocolException("Redirect URI does not specify a valid host name: " + uRI);
            }
            if (!httpRoute.getTargetHost().equals(httpHost)) {
                this.log.debug("Resetting target auth state");
                this.targetAuthState.reset();
                object3 = this.proxyAuthState.getAuthScheme();
                if (object3 != null && object3.isConnectionBased()) {
                    this.log.debug("Resetting proxy auth state");
                    this.proxyAuthState.reset();
                }
            }
            object3 = this.wrapRequest((HttpRequest)object2);
            ((AbstractHttpMessage)object3).setParams(httpParams);
            HttpRoute httpRoute2 = this.determineRoute(httpHost, (HttpRequest)object3, httpContext);
            RoutedRequest routedRequest2 = new RoutedRequest((RequestWrapper)object3, httpRoute2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Redirecting to '" + uRI + "' via " + httpRoute2);
            }
            return routedRequest2;
        }
        return null;
    }

    private void abortConnection() {
        ManagedClientConnection managedClientConnection = this.managedConn;
        if (managedClientConnection != null) {
            block5: {
                this.managedConn = null;
                try {
                    managedClientConnection.abortConnection();
                }
                catch (IOException iOException) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug(iOException.getMessage(), iOException);
                }
            }
            try {
                managedClientConnection.releaseConnection();
            }
            catch (IOException iOException) {
                this.log.debug("Error releasing connection", iOException);
            }
        }
    }
}

