/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.util.json.AwsJsonReader;
import com.amazonaws.util.json.JsonUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

public class JsonPolicyReader {
    private static final String PRINCIPAL_SCHEMA_USER = "AWS";
    private static final String PRINCIPAL_SCHEMA_SERVICE = "Service";
    private static final String PRINICIPAL_SCHEMA_FEDERATED = "Federated";
    private AwsJsonReader reader;

    public Policy createPolicyFromJsonString(String jsonString) {
        if (jsonString == null) {
            throw new IllegalArgumentException("JSON string cannot be null");
        }
        this.reader = JsonUtils.getJsonReader(new StringReader(jsonString));
        Policy policy = new Policy();
        LinkedList<Statement> statements = new LinkedList<Statement>();
        try {
            this.reader.beginObject();
            while (this.reader.hasNext()) {
                String name = this.reader.nextName();
                if ("Id".equals(name)) {
                    policy.setId(this.reader.nextString());
                    continue;
                }
                if ("Statement".equals(name)) {
                    this.reader.beginArray();
                    while (this.reader.hasNext()) {
                        statements.add(this.statementOf(this.reader));
                    }
                    this.reader.endArray();
                    continue;
                }
                this.reader.skipValue();
            }
            this.reader.endObject();
        }
        catch (Exception e) {
            String message = "Unable to generate policy object fron JSON string " + e.getMessage();
            throw new IllegalArgumentException(message, e);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {}
        }
        policy.setStatements(statements);
        return policy;
    }

    private Statement statementOf(AwsJsonReader reader) throws IOException {
        Statement statement = new Statement(null);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("Effect".equals(name)) {
                statement.setEffect(Statement.Effect.valueOf(reader.nextString()));
                continue;
            }
            if ("Sid".equals(name)) {
                statement.setId(reader.nextString());
                continue;
            }
            if ("Action".equals(name)) {
                statement.setActions(this.actionsOf(reader));
                continue;
            }
            if ("Resource".equals(name)) {
                statement.setResources(this.resourcesOf(reader));
                continue;
            }
            if ("Principal".equals(name)) {
                statement.setPrincipals(this.principalOf(reader));
                continue;
            }
            if ("Condition".equals(name)) {
                statement.setConditions(this.conditionsOf(reader));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return statement.getEffect() == null ? null : statement;
    }

    private List<Action> actionsOf(AwsJsonReader reader) throws IOException {
        LinkedList<Action> actions = new LinkedList<Action>();
        if (reader.isContainer()) {
            reader.beginArray();
            while (reader.hasNext()) {
                actions.add(new NamedAction(reader.nextString()));
            }
            reader.endArray();
        } else {
            actions.add(new NamedAction(reader.nextString()));
        }
        return actions;
    }

    private List<Resource> resourcesOf(AwsJsonReader reader) throws IOException {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        if (reader.isContainer()) {
            reader.beginArray();
            while (reader.hasNext()) {
                resources.add(new Resource(reader.nextString()));
            }
            reader.endArray();
        } else {
            resources.add(new Resource(reader.nextString()));
        }
        return resources;
    }

    private List<Principal> principalOf(AwsJsonReader reader) throws IOException {
        LinkedList<Principal> principals = new LinkedList<Principal>();
        if (reader.isContainer()) {
            reader.beginObject();
            while (reader.hasNext()) {
                String schema = reader.nextName();
                if (reader.isContainer()) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        principals.add(this.createPrincipal(schema, reader.nextString()));
                    }
                    reader.endArray();
                    continue;
                }
                principals.add(this.createPrincipal(schema, reader.nextString()));
            }
            reader.endObject();
        } else {
            String s = reader.nextString();
            if ("*".equals(s)) {
                principals.add(Principal.All);
            } else {
                throw new IllegalArgumentException("Invalid principals: " + s);
            }
        }
        return principals;
    }

    private Principal createPrincipal(String string, String string2) {
        if (string.equalsIgnoreCase(PRINCIPAL_SCHEMA_USER)) {
            return new Principal(string2);
        }
        if (string.equalsIgnoreCase(PRINCIPAL_SCHEMA_SERVICE)) {
            return new Principal(string, string2);
        }
        if (string.equalsIgnoreCase(PRINICIPAL_SCHEMA_FEDERATED)) {
            if (Principal.WebIdentityProviders.fromString(string2) != null) {
                return new Principal(Principal.WebIdentityProviders.fromString(string2));
            }
            return new Principal(PRINICIPAL_SCHEMA_FEDERATED, string2);
        }
        throw new AmazonClientException("Schema " + string + " is not a valid value for the principal.");
    }

    private List<Condition> conditionsOf(AwsJsonReader reader) throws IOException {
        LinkedList<Condition> conditionList = new LinkedList<Condition>();
        reader.beginObject();
        while (reader.hasNext()) {
            this.convertConditionRecord(conditionList, reader.nextName(), reader);
        }
        reader.endObject();
        return conditionList;
    }

    private void convertConditionRecord(List<Condition> conditions, String conditionType, AwsJsonReader reader) throws IOException {
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            LinkedList<String> values = new LinkedList<String>();
            if (reader.isContainer()) {
                reader.beginArray();
                while (reader.hasNext()) {
                    values.add(reader.nextString());
                }
                reader.endArray();
            } else {
                values.add(reader.nextString());
            }
            conditions.add(new Condition().withType(conditionType).withConditionKey(name).withValues(values));
        }
        reader.endObject();
    }

    private static class NamedAction
    implements Action {
        private final String actionName;

        public NamedAction(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public String getActionName() {
            return this.actionName;
        }
    }
}

