/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.config;

import com.amazonaws.internal.config.HttpClientConfig;
import com.amazonaws.internal.config.SignerConfig;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import java.util.HashMap;
import java.util.Map;

public class InternalConfig {
    private static final Log log = LogFactory.getLog(InternalConfig.class);
    private static final String SERVICE_REGION_DELIMITOR = "/";
    private final SignerConfig defaultSignerConfig = InternalConfig.getDefaultSigner();
    private final Map<String, SignerConfig> serviceRegionSigners;
    private final Map<String, SignerConfig> regionSigners = InternalConfig.getDefaultRegionSigners();
    private final Map<String, SignerConfig> serviceSigners;
    private final Map<String, HttpClientConfig> httpClients;

    InternalConfig() {
        this.regionSigners.putAll(InternalConfig.getOverrideRegionSigners());
        this.serviceSigners = InternalConfig.getDefaultServiceSigners();
        this.serviceSigners.putAll(InternalConfig.getOverrideServiceSigners());
        this.serviceRegionSigners = InternalConfig.getDefaultServiceRegionSigners();
        this.serviceRegionSigners.putAll(InternalConfig.getOverrideServiceRegionSigners());
        this.httpClients = InternalConfig.getDefaultHttpClients();
        this.httpClients.putAll(InternalConfig.getOverrideHttpClients());
    }

    public SignerConfig getSignerConfig(String serviceName) {
        return this.getSignerConfig(serviceName, null);
    }

    public HttpClientConfig getHttpClientConfig(String httpClientName) {
        return this.httpClients.get(httpClientName);
    }

    public SignerConfig getSignerConfig(String serviceName, String regionName) {
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        SignerConfig signerConfig = null;
        if (regionName != null) {
            String key = serviceName + SERVICE_REGION_DELIMITOR + regionName;
            signerConfig = this.serviceRegionSigners.get(key);
            if (signerConfig != null) {
                return signerConfig;
            }
            signerConfig = this.regionSigners.get(regionName);
            if (signerConfig != null) {
                return signerConfig;
            }
        }
        return (signerConfig = this.serviceSigners.get(serviceName)) == null ? this.defaultSignerConfig : signerConfig;
    }

    private static Map<String, HttpClientConfig> getDefaultHttpClients() {
        HashMap<String, HttpClientConfig> ret = new HashMap<String, HttpClientConfig>();
        ret.put("AmazonSimpleWorkflowClient", new HttpClientConfig("swf"));
        ret.put("AmazonCloudWatchClient", new HttpClientConfig("monitoring"));
        ret.put("DataPipelineClient", new HttpClientConfig("datapipeline"));
        ret.put("AmazonIdentityManagementClient", new HttpClientConfig("iam"));
        ret.put("AmazonSimpleDBClient", new HttpClientConfig("sdb"));
        ret.put("AmazonSimpleEmailServiceClient", new HttpClientConfig("email"));
        ret.put("AWSSecurityTokenServiceClient", new HttpClientConfig("sts"));
        ret.put("AmazonCognitoIdentityClient", new HttpClientConfig("cognito-identity"));
        ret.put("AmazonCognitoSyncClient", new HttpClientConfig("cognito-sync"));
        return ret;
    }

    private static Map<String, SignerConfig> getDefaultRegionSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        ret.put("eu-central-1", new SignerConfig("AWS4SignerType"));
        ret.put("cn-north-1", new SignerConfig("AWS4SignerType"));
        return ret;
    }

    private static Map<String, SignerConfig> getDefaultServiceRegionSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        ret.put("s3/eu-central-1", new SignerConfig("AWSS3V4SignerType"));
        ret.put("s3/cn-north-1", new SignerConfig("AWSS3V4SignerType"));
        return ret;
    }

    private static Map<String, SignerConfig> getDefaultServiceSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        ret.put("ec2", new SignerConfig("QueryStringSignerType"));
        ret.put("email", new SignerConfig("AWS3SignerType"));
        ret.put("importexport", new SignerConfig("QueryStringSignerType"));
        ret.put("route53", new SignerConfig("AWS3SignerType"));
        ret.put("s3", new SignerConfig("S3SignerType"));
        ret.put("sdb", new SignerConfig("QueryStringSignerType"));
        ret.put("cloudsearchdomain", new SignerConfig("NoOpSignerType"));
        return ret;
    }

    private static SignerConfig getDefaultSigner() {
        return new SignerConfig("AWS4SignerType");
    }

    private static Map<String, HttpClientConfig> getOverrideHttpClients() {
        HashMap<String, HttpClientConfig> ret = new HashMap<String, HttpClientConfig>();
        return ret;
    }

    private static Map<String, SignerConfig> getOverrideRegionSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        return ret;
    }

    private static Map<String, SignerConfig> getOverrideServiceRegionSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        return ret;
    }

    private static Map<String, SignerConfig> getOverrideServiceSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        return ret;
    }

    void dump() {
        StringBuilder sb = new StringBuilder().append("defaultSignerConfig: ").append(this.defaultSignerConfig).append("\n").append("serviceRegionSigners: ").append(this.serviceRegionSigners).append("\n").append("regionSigners: ").append(this.regionSigners).append("\n").append("serviceSigners: ").append(this.serviceSigners);
        log.debug(sb.toString());
    }

    public static class Factory {
        private static final InternalConfig SINGELTON;

        public static InternalConfig getInternalConfig() {
            return SINGELTON;
        }

        static {
            InternalConfig config = null;
            try {
                config = new InternalConfig();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Fatal: Failed to load the internal config for AWS Java SDK", ex);
            }
            SINGELTON = config;
        }
    }
}

