/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class IdentityDescription
implements Serializable {
    private String identityId;
    private ListWithAutoConstructFlag<String> logins;
    private Date creationDate;
    private Date lastModifiedDate;

    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public IdentityDescription withIdentityId(String identityId) {
        this.identityId = identityId;
        return this;
    }

    public List<String> getLogins() {
        if (this.logins == null) {
            this.logins = new ListWithAutoConstructFlag();
            this.logins.setAutoConstruct(true);
        }
        return this.logins;
    }

    public void setLogins(Collection<String> logins) {
        if (logins == null) {
            this.logins = null;
            return;
        }
        ListWithAutoConstructFlag loginsCopy = new ListWithAutoConstructFlag(logins.size());
        loginsCopy.addAll(logins);
        this.logins = loginsCopy;
    }

    public IdentityDescription withLogins(String ... logins) {
        if (this.getLogins() == null) {
            this.setLogins(new ArrayList<String>(logins.length));
        }
        for (String value : logins) {
            this.getLogins().add(value);
        }
        return this;
    }

    public IdentityDescription withLogins(Collection<String> logins) {
        if (logins == null) {
            this.logins = null;
        } else {
            ListWithAutoConstructFlag loginsCopy = new ListWithAutoConstructFlag(logins.size());
            loginsCopy.addAll(logins);
            this.logins = loginsCopy;
        }
        return this;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public IdentityDescription withCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public IdentityDescription withLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityId() != null) {
            sb.append("IdentityId: " + this.getIdentityId() + ",");
        }
        if (this.getLogins() != null) {
            sb.append("Logins: " + this.getLogins() + ",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: " + this.getCreationDate() + ",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: " + this.getLastModifiedDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityId() == null ? 0 : this.getIdentityId().hashCode());
        hashCode = 31 * hashCode + (this.getLogins() == null ? 0 : ((Object)this.getLogins()).hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDescription)) {
            return false;
        }
        IdentityDescription other = (IdentityDescription)obj;
        if (other.getIdentityId() == null ^ this.getIdentityId() == null) {
            return false;
        }
        if (other.getIdentityId() != null && !other.getIdentityId().equals(this.getIdentityId())) {
            return false;
        }
        if (other.getLogins() == null ^ this.getLogins() == null) {
            return false;
        }
        if (other.getLogins() != null && !((Object)other.getLogins()).equals(this.getLogins())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        return other.getLastModifiedDate() == null || other.getLastModifiedDate().equals(this.getLastModifiedDate());
    }
}

