/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentity.model.IdentityDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListIdentitiesResult
implements Serializable {
    private String identityPoolId;
    private ListWithAutoConstructFlag<IdentityDescription> identities;
    private String nextToken;

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public ListIdentitiesResult withIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
        return this;
    }

    public List<IdentityDescription> getIdentities() {
        if (this.identities == null) {
            this.identities = new ListWithAutoConstructFlag();
            this.identities.setAutoConstruct(true);
        }
        return this.identities;
    }

    public void setIdentities(Collection<IdentityDescription> identities) {
        if (identities == null) {
            this.identities = null;
            return;
        }
        ListWithAutoConstructFlag identitiesCopy = new ListWithAutoConstructFlag(identities.size());
        identitiesCopy.addAll(identities);
        this.identities = identitiesCopy;
    }

    public ListIdentitiesResult withIdentities(IdentityDescription ... identities) {
        if (this.getIdentities() == null) {
            this.setIdentities(new ArrayList<IdentityDescription>(identities.length));
        }
        for (IdentityDescription value : identities) {
            this.getIdentities().add(value);
        }
        return this;
    }

    public ListIdentitiesResult withIdentities(Collection<IdentityDescription> identities) {
        if (identities == null) {
            this.identities = null;
        } else {
            ListWithAutoConstructFlag identitiesCopy = new ListWithAutoConstructFlag(identities.size());
            identitiesCopy.addAll(identities);
            this.identities = identitiesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListIdentitiesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getIdentities() != null) {
            sb.append("Identities: " + this.getIdentities() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentities() == null ? 0 : ((Object)this.getIdentities()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesResult)) {
            return false;
        }
        ListIdentitiesResult other = (ListIdentitiesResult)obj;
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getIdentities() == null ^ this.getIdentities() == null) {
            return false;
        }
        if (other.getIdentities() != null && !((Object)other.getIdentities()).equals(this.getIdentities())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

