/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetFederationTokenRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String name;
    private String policy;
    private List<PolicyDescriptorType> policyArns;
    private Integer durationSeconds;

    public GetFederationTokenRequest() {
    }

    public GetFederationTokenRequest(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GetFederationTokenRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public GetFederationTokenRequest withPolicy(String policy) {
        this.policy = policy;
        return this;
    }

    public List<PolicyDescriptorType> getPolicyArns() {
        return this.policyArns;
    }

    public void setPolicyArns(Collection<PolicyDescriptorType> policyArns) {
        if (policyArns == null) {
            this.policyArns = null;
            return;
        }
        this.policyArns = new ArrayList<PolicyDescriptorType>(policyArns);
    }

    public GetFederationTokenRequest withPolicyArns(PolicyDescriptorType ... policyArns) {
        if (this.getPolicyArns() == null) {
            this.policyArns = new ArrayList<PolicyDescriptorType>(policyArns.length);
        }
        for (PolicyDescriptorType value : policyArns) {
            this.policyArns.add(value);
        }
        return this;
    }

    public GetFederationTokenRequest withPolicyArns(Collection<PolicyDescriptorType> policyArns) {
        this.setPolicyArns(policyArns);
        return this;
    }

    public Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public GetFederationTokenRequest withDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getPolicy() != null) {
            sb.append("Policy: " + this.getPolicy() + ",");
        }
        if (this.getPolicyArns() != null) {
            sb.append("PolicyArns: " + this.getPolicyArns() + ",");
        }
        if (this.getDurationSeconds() != null) {
            sb.append("DurationSeconds: " + this.getDurationSeconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyArns() == null ? 0 : this.getPolicyArns().hashCode());
        hashCode = 31 * hashCode + (this.getDurationSeconds() == null ? 0 : this.getDurationSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFederationTokenRequest)) {
            return false;
        }
        GetFederationTokenRequest other = (GetFederationTokenRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        if (other.getPolicy() != null && !other.getPolicy().equals(this.getPolicy())) {
            return false;
        }
        if (other.getPolicyArns() == null ^ this.getPolicyArns() == null) {
            return false;
        }
        if (other.getPolicyArns() != null && !other.getPolicyArns().equals(this.getPolicyArns())) {
            return false;
        }
        if (other.getDurationSeconds() == null ^ this.getDurationSeconds() == null) {
            return false;
        }
        return other.getDurationSeconds() == null || other.getDurationSeconds().equals(this.getDurationSeconds());
    }
}

