/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class HttpResponse {
    private final String statusText;
    private final int statusCode;
    private final InputStream rawContent;
    private final Map<String, String> headers;
    private InputStream content;

    private HttpResponse(String statusText, int statusCode, Map<String, String> headers, InputStream rawContent) {
        this.statusText = statusText;
        this.statusCode = statusCode;
        this.headers = headers;
        this.rawContent = rawContent;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent() throws IOException {
        if (this.content == null) {
            HttpResponse httpResponse = this;
            synchronized (httpResponse) {
                this.content = this.rawContent != null && "gzip".equals(this.headers.get("Content-Encoding")) ? new GZIPInputStream(this.rawContent) : this.rawContent;
            }
        }
        return this.content;
    }

    public InputStream getRawContent() throws IOException {
        return this.rawContent;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String statusText;
        private int statusCode;
        private InputStream content;
        private final Map<String, String> headers = new HashMap<String, String>();

        public Builder statusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder content(InputStream content) {
            this.content = content;
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public HttpResponse build() {
            return new HttpResponse(this.statusText, this.statusCode, Collections.unmodifiableMap(this.headers), this.content);
        }
    }
}

