/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class UrlHttpClient
implements HttpClient {
    private final ClientConfiguration config;
    private SSLContext sc = null;

    public UrlHttpClient(ClientConfiguration config) {
        this.config = config;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws IOException {
        URL url = request.getUri().toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.configureConnection(connection);
        this.applyHeadersAndMethod(request, connection);
        this.writeContentToConnection(request, connection);
        return this.createHttpResponse(request, connection);
    }

    HttpResponse createHttpResponse(HttpRequest request, HttpURLConnection connection) throws IOException {
        String statusText = connection.getResponseMessage();
        int statusCode = connection.getResponseCode();
        InputStream content = connection.getErrorStream();
        if (content == null && !request.getMethod().equals("HEAD")) {
            try {
                content = connection.getInputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HttpResponse.Builder builder = HttpResponse.builder().statusCode(statusCode).statusText(statusText).content(content);
        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            builder.header(header.getKey(), header.getValue().get(0));
        }
        return builder.build();
    }

    @Override
    public void shutdown() {
    }

    void writeContentToConnection(HttpRequest request, HttpURLConnection connection) throws IOException {
        if (request.getContent() != null && request.getContentLength() >= 0L) {
            connection.setDoOutput(true);
            connection.setFixedLengthStreamingMode((int)request.getContentLength());
            OutputStream os = connection.getOutputStream();
            this.write(request.getContent(), os);
            os.flush();
            os.close();
        }
    }

    HttpURLConnection applyHeadersAndMethod(HttpRequest request, HttpURLConnection connection) throws ProtocolException {
        if (request.getHeaders() != null && !request.getHeaders().isEmpty()) {
            for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                String key = header.getKey();
                if (key.equals("Content-Length") || key.equals("Host")) continue;
                if (key.equals("Expect")) {
                    // empty if block
                }
                connection.setRequestProperty(key, header.getValue());
            }
        }
        String method = request.getMethod();
        connection.setRequestMethod(method);
        return connection;
    }

    private void write(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = is.read(buf)) != -1) {
            os.write(buf, 0, len);
        }
    }

    void configureConnection(HttpURLConnection connection) {
        connection.setConnectTimeout(this.config.getConnectionTimeout());
        connection.setReadTimeout(this.config.getSocketTimeout());
        connection.setInstanceFollowRedirects(false);
        connection.setUseCaches(false);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            if (this.config.getTrustManager() != null) {
                this.enableCustomTrustManager(https);
            }
        }
    }

    private void enableCustomTrustManager(HttpsURLConnection connection) {
        if (this.sc == null) {
            TrustManager[] customTrustManagers = new TrustManager[]{this.config.getTrustManager()};
            try {
                this.sc = SSLContext.getInstance("TLS");
                this.sc.init(null, customTrustManagers, null);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        connection.setSSLSocketFactory(this.sc.getSocketFactory());
    }
}

