/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class UrlHttpClient
implements HttpClient {
    private static final String TAG = "amazonaws";
    private static final Log log = LogFactory.getLog(UrlHttpClient.class);
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final int BUFFER_SIZE_MULTIPLIER = 8;
    private final ClientConfiguration config;
    private SSLContext sc = null;

    public UrlHttpClient(ClientConfiguration config) {
        this.config = config;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws IOException {
        URL url = request.getUri().toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        CurlBuilder curlBuilder = this.config.isCurlLogging() ? new CurlBuilder(request.getUri().toURL()) : null;
        this.configureConnection(request, connection);
        this.applyHeadersAndMethod(request, connection, curlBuilder);
        this.writeContentToConnection(request, connection, curlBuilder);
        if (curlBuilder != null) {
            if (curlBuilder.isValid()) {
                this.printToLog(curlBuilder.build());
            } else {
                this.printToLog("Failed to create curl, content too long");
            }
        }
        return this.createHttpResponse(request, connection);
    }

    HttpResponse createHttpResponse(HttpRequest request, HttpURLConnection connection) throws IOException {
        String statusText = connection.getResponseMessage();
        int statusCode = connection.getResponseCode();
        InputStream content = connection.getErrorStream();
        if (content == null && !"HEAD".equals(request.getMethod())) {
            try {
                content = connection.getInputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HttpResponse.Builder builder = HttpResponse.builder().statusCode(statusCode).statusText(statusText).content(content);
        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            builder.header(header.getKey(), header.getValue().get(0));
        }
        return builder.build();
    }

    @Override
    public void shutdown() {
    }

    void writeContentToConnection(HttpRequest request, HttpURLConnection connection) throws IOException {
        this.writeContentToConnection(request, connection, null);
    }

    void writeContentToConnection(HttpRequest request, HttpURLConnection connection, CurlBuilder curlBuilder) throws IOException {
        if (request.getContent() != null && request.getContentLength() >= 0L) {
            connection.setDoOutput(true);
            if (!request.isStreaming()) {
                connection.setFixedLengthStreamingMode((int)request.getContentLength());
            }
            OutputStream os = connection.getOutputStream();
            ByteBuffer curlBuffer = null;
            if (curlBuilder != null) {
                if (request.getContentLength() < Integer.MAX_VALUE) {
                    curlBuffer = ByteBuffer.allocate((int)request.getContentLength());
                } else {
                    curlBuilder.setContentOverflow(true);
                }
            }
            this.write(request.getContent(), os, curlBuilder, curlBuffer);
            if (curlBuilder != null && curlBuffer != null && curlBuffer.position() != 0) {
                curlBuilder.setContent(new String(curlBuffer.array(), "UTF-8"));
            }
            os.flush();
            os.close();
        }
    }

    HttpURLConnection applyHeadersAndMethod(HttpRequest request, HttpURLConnection connection) throws ProtocolException {
        return this.applyHeadersAndMethod(request, connection, null);
    }

    HttpURLConnection applyHeadersAndMethod(HttpRequest request, HttpURLConnection connection, CurlBuilder curlBuilder) throws ProtocolException {
        if (request.getHeaders() != null && !request.getHeaders().isEmpty()) {
            if (curlBuilder != null) {
                curlBuilder.setHeaders(request.getHeaders());
            }
            for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                String key = header.getKey();
                if (key.equals("Content-Length") || key.equals("Host")) continue;
                if (key.equals("Expect")) {
                    // empty if block
                }
                connection.setRequestProperty(key, header.getValue());
            }
        }
        String method = request.getMethod();
        connection.setRequestMethod(method);
        if (curlBuilder != null) {
            curlBuilder.setMethod(method);
        }
        return connection;
    }

    protected void printToLog(String message) {
        log.debug(message);
    }

    protected HttpURLConnection getUrlConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private void write(InputStream is, OutputStream os, CurlBuilder curlBuilder, ByteBuffer curlBuffer) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = is.read(buf)) != -1) {
            try {
                if (curlBuffer != null) {
                    curlBuffer.put(buf, 0, len);
                }
            }
            catch (BufferOverflowException e) {
                curlBuilder.setContentOverflow(true);
            }
            os.write(buf, 0, len);
        }
    }

    void configureConnection(HttpRequest request, HttpURLConnection connection) {
        connection.setConnectTimeout(this.config.getConnectionTimeout());
        connection.setReadTimeout(this.config.getSocketTimeout());
        connection.setInstanceFollowRedirects(false);
        connection.setUseCaches(false);
        if (request.isStreaming()) {
            connection.setChunkedStreamingMode(0);
        }
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            if (this.config.getTrustManager() != null) {
                this.enableCustomTrustManager(https);
            }
        }
    }

    private void enableCustomTrustManager(HttpsURLConnection connection) {
        if (this.sc == null) {
            TrustManager[] customTrustManagers = new TrustManager[]{this.config.getTrustManager()};
            try {
                this.sc = SSLContext.getInstance("TLS");
                this.sc.init(null, customTrustManagers, null);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        connection.setSSLSocketFactory(this.sc.getSocketFactory());
    }

    protected final class CurlBuilder {
        private final URL url;
        private String method = null;
        private final HashMap<String, String> headers = new HashMap();
        private String content = null;
        private boolean contentOverflow = false;

        public CurlBuilder(URL url) {
            if (url == null) {
                throw new IllegalArgumentException("Must have a valid url");
            }
            this.url = url;
        }

        public CurlBuilder setMethod(String method) {
            this.method = method;
            return this;
        }

        public CurlBuilder setHeaders(Map<String, String> headers) {
            this.headers.clear();
            this.headers.putAll(headers);
            return this;
        }

        public CurlBuilder setContent(String content) {
            this.content = content;
            return this;
        }

        public CurlBuilder setContentOverflow(boolean contentOverflow) {
            this.contentOverflow = contentOverflow;
            return this;
        }

        public boolean isValid() {
            return !this.contentOverflow;
        }

        public String build() {
            if (!this.isValid()) {
                throw new IllegalStateException("Invalid state, cannot create curl command");
            }
            StringBuilder stringBuilder = new StringBuilder("curl");
            if (this.method != null) {
                stringBuilder.append(" -X ").append(this.method);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                stringBuilder.append(" -H \"").append(entry.getKey()).append(":").append(entry.getValue()).append("\"");
            }
            if (this.content != null) {
                stringBuilder.append(" -d '").append(this.content).append("'");
            }
            return stringBuilder.append(" ").append(this.url.toString()).toString();
        }
    }
}

