/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisRecorderConfig;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.FileRecordStore;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.JSONRecordAdapter;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.RecordStore;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.PutRecordsResultEntry;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class KinesisRecorder {
    private static final String TAG = "KinesisRecorder";
    private RecordStore recordStore;
    private JSONRecordAdapter adapter;
    private AmazonKinesisClient client;
    private KinesisRecorderConfig config;
    private File directory;
    private static final String USER_AGENT = KinesisRecorder.class.getName() + "/" + VersionInfoUtils.getVersion();

    public KinesisRecorder(File file, Regions regions, AWSCredentialsProvider aWSCredentialsProvider) {
        this(file, regions, aWSCredentialsProvider, new KinesisRecorderConfig());
    }

    public KinesisRecorder(File file, Regions regions, AWSCredentialsProvider aWSCredentialsProvider, KinesisRecorderConfig kinesisRecorderConfig) {
        if (file == null || aWSCredentialsProvider == null || regions == null || kinesisRecorderConfig == null) {
            throw new IllegalArgumentException("You must pass a non-null credentialsProvider, region, directory, and config to KinesisRecordStore");
        }
        this.config = new KinesisRecorderConfig(kinesisRecorderConfig);
        this.directory = file;
        this.recordStore = new FileRecordStore(file, this.config);
        this.adapter = new JSONRecordAdapter();
        this.client = new AmazonKinesisClient(aWSCredentialsProvider, this.config.getClientConfiguration());
        this.client.setRegion(Region.getRegion((Regions)regions));
    }

    public void saveRecord(byte[] byArray, String string) {
        if (string == null || string.isEmpty() || byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("You must pass a non-null, non-empty stream name and non-empty data");
        }
        PutRecordRequest putRecordRequest = new PutRecordRequest().withData(ByteBuffer.wrap(byArray)).withStreamName(string).withPartitionKey(UUID.randomUUID().toString());
        this.recordStore.put(this.adapter.translateFromRecord(putRecordRequest).toString());
    }

    public synchronized void submitAllRecords() {
        RecordStore.RecordIterator recordIterator = this.recordStore.iterator();
        LinkedList<PutRecordsRequestEntry> linkedList = new LinkedList<PutRecordsRequestEntry>();
        String string = null;
        JSONObject jSONObject = null;
        while (recordIterator.hasNext()) {
            try {
                if (jSONObject == null) {
                    jSONObject = new JSONObject(recordIterator.peek());
                }
                if (linkedList.size() == 0) {
                    string = JSONRecordAdapter.getStreamName(jSONObject);
                }
                if (this.belongsInBatch(jSONObject, string, linkedList)) {
                    linkedList.add(new PutRecordsRequestEntry().withData(JSONRecordAdapter.getData(jSONObject)).withPartitionKey(JSONRecordAdapter.getPartitionKey(jSONObject)));
                    jSONObject = null;
                    recordIterator.next();
                    continue;
                }
                this.submitAndUpdate(string, linkedList, recordIterator);
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)"Record in record store was improperly formatted JSON, record will be dropped", (Throwable)jSONException);
                jSONObject = null;
                recordIterator.next();
            }
        }
        if (linkedList.size() > 0) {
            this.submitAndUpdate(string, linkedList, recordIterator);
        }
    }

    public synchronized void deleteAllRecords() {
        this.recordStore.iterator().removeAllRecords();
    }

    public long getDiskBytesUsed() {
        return this.getRecursiveSizeOfDirectory(this.directory);
    }

    private long getRecursiveSizeOfDirectory(File file) {
        if (!file.isDirectory()) {
            return this.directory.length();
        }
        long l = 0L;
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                l += file2.length();
                continue;
            }
            if (!file2.isDirectory()) continue;
            l += this.getRecursiveSizeOfDirectory(file2);
        }
        return l;
    }

    public long getDiskByteLimit() {
        return this.config.getMaxStorageSize();
    }

    public KinesisRecorderConfig getKinesisRecorderConfig() {
        return this.config;
    }

    private boolean belongsInBatch(JSONObject jSONObject, String string, Collection<PutRecordsRequestEntry> collection) throws JSONException {
        boolean bl = collection.size() == 0 || JSONRecordAdapter.getStreamName(jSONObject).equals(string);
        boolean bl2 = collection.size() + 1 <= 100;
        return bl && bl2;
    }

    private boolean isRecoverable(AmazonServiceException amazonServiceException) {
        String string = amazonServiceException.getErrorCode();
        return !string.equalsIgnoreCase("ValidationError") && !string.equalsIgnoreCase("MissingParameter") && !string.equalsIgnoreCase("MissingAction") && !string.equalsIgnoreCase("MalformedQueryString") && !string.equalsIgnoreCase("InvalidQueryParameter") && !string.equalsIgnoreCase("InvalidParameterValue") && !string.equalsIgnoreCase("InvalidParameterCombination");
    }

    private void saveEntries(String string, Collection<PutRecordsRequestEntry> collection) {
        for (PutRecordsRequestEntry putRecordsRequestEntry : collection) {
            this.saveEntry(string, putRecordsRequestEntry);
        }
    }

    private void saveEntry(String string, PutRecordsRequestEntry putRecordsRequestEntry) {
        this.saveRecord(putRecordsRequestEntry.getData().array(), string);
    }

    private void submit(String string, List<PutRecordsRequestEntry> list) {
        PutRecordsRequest putRecordsRequest = new PutRecordsRequest().withStreamName(string).withRecords(list);
        try {
            PutRecordsResult putRecordsResult = this.client.putRecords(putRecordsRequest);
            for (int i = 0; i < putRecordsResult.getRecords().size(); ++i) {
                PutRecordsResultEntry putRecordsResultEntry = putRecordsResult.getRecords().get(i);
                if (putRecordsResultEntry.getErrorCode() == null || putRecordsResultEntry.getErrorCode().isEmpty()) continue;
                this.saveEntry(string, list.get(i));
            }
        }
        catch (AmazonClientException amazonClientException) {
            if (PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION.shouldRetry((AmazonWebServiceRequest)putRecordsRequest, amazonClientException, 1)) {
                Log.w((String)TAG, (String)"Error occured while sending request, request appears to be valid stopping submission but retaining records", (Throwable)amazonClientException);
                this.saveEntries(string, list);
            } else if (amazonClientException instanceof AmazonServiceException) {
                if (!this.isRecoverable((AmazonServiceException)amazonClientException)) {
                    Log.e((String)TAG, (String)"ServiceException in submit all, the last request is presumed to be the cause and will be dropped", (Throwable)amazonClientException);
                } else {
                    this.saveEntries(string, list);
                    Log.e((String)TAG, (String)"ServiceException in submit all, the values of the data inside the requests appears valid.  The request will be kept", (Throwable)amazonClientException);
                }
            }
            throw amazonClientException;
        }
    }

    private void submitAndUpdate(String string, List<PutRecordsRequestEntry> list, RecordStore.RecordIterator recordIterator) {
        recordIterator.removeReadRecords();
        this.submit(string, list);
        list.clear();
    }
}

