/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class FileManager {
    private final File directory;

    public FileManager(File file) {
        this.directory = file;
    }

    public File createDirectory(String string) {
        File file = new File(this.directory, string);
        if (!file.exists() && !file.mkdirs()) {
            return null;
        }
        return file;
    }

    public File getDirectory(String string) {
        File file = new File(this.directory, string);
        return file;
    }

    public Set<File> listFilesInDirectory(String string) {
        File file = new File(this.directory, string);
        return this.listFilesInDirectory(file);
    }

    public Set<File> listFilesInDirectory(File file) {
        HashSet<File> hashSet = new HashSet<File>();
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                hashSet.add(file2);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public File createFile(String string) throws IOException {
        File file = new File(this.directory, string);
        return this.createFile(file);
    }

    public File createFile(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            return null;
        }
        return file;
    }

    public boolean deleteFile(String string) {
        File file = new File(this.directory, string);
        return this.deleteFile(file);
    }

    public boolean deleteFile(File file) {
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public InputStream newInputStream(String string) throws FileNotFoundException {
        File file = new File(this.directory, string);
        return this.newInputStream(file);
    }

    public InputStream newInputStream(File file) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return fileInputStream;
    }

    public OutputStream newOutputStream(String string, boolean bl) throws FileNotFoundException {
        File file = new File(this.directory, string);
        return this.newOutputStream(file, bl);
    }

    public OutputStream newOutputStream(File file, boolean bl) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
        return fileOutputStream;
    }
}

