/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisRecorderConfig;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.FileManager;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.RecordStore;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantLock;

public class FileRecordStore
implements RecordStore {
    private static final Logger logger = Logger.getLogger(FileRecordStore.class);
    static final String KEY_MAX_STORAGE_SIZE = "maxStorageSize";
    static final double ERROR_LENGTH_THRESHOLD_PERCENTAGE = 1.1;
    private final ReentrantLock accessLock = new ReentrantLock(true);
    private File recordFile;
    private FileManager fileManager;
    private KinesisRecorderConfig config;

    public FileRecordStore(File file, KinesisRecorderConfig kinesisRecorderConfig) {
        this.fileManager = new FileManager(file);
        this.config = kinesisRecorderConfig;
        this.tryCreateRecordsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String string) {
        boolean bl = false;
        Writer writer = null;
        this.accessLock.lock();
        try {
            writer = this.tryInitializeWriter();
            if (writer != null) {
                if (this.recordFile.length() + (long)string.getBytes().length <= this.config.getMaxStorageSize()) {
                    writer.write(string + "\n");
                    writer.flush();
                    bl = true;
                } else {
                    logger.e("The record file exceeded its allowed size of " + this.config.getMaxStorageSize() + " bytes");
                }
            }
        }
        catch (IOException iOException) {
            logger.e("Failed to persist the record", iOException);
        }
        finally {
            this.accessLock.unlock();
            this.tryCloseWriter(writer);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCreateRecordsFile() {
        if (this.recordFile != null && this.recordFile.exists()) {
            return true;
        }
        FileRecordStore fileRecordStore = this;
        synchronized (fileRecordStore) {
            if (this.recordFile != null && this.recordFile.exists()) {
                return true;
            }
            try {
                File file = this.fileManager.createDirectory("KinesisRecorder");
                this.recordFile = this.fileManager.createFile(new File(file, "KinesisRecords"));
                return true;
            }
            catch (IOException iOException) {
                logger.deve("Unable to open records file");
                logger.e("An error occurred while attempting to create/open the records file", iOException);
                return false;
            }
        }
    }

    private Writer tryInitializeWriter() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            if (!this.tryCreateRecordsFile()) {
                throw new AmazonClientException("Unable to create record file");
            }
            OutputStream outputStream = this.fileManager.newOutputStream(this.recordFile, true);
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.e("Records file not found to persist record to", fileNotFoundException);
            throw new AmazonClientException("Unable to open record file writer", (Throwable)fileNotFoundException);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unexpected error while creating recordsFile writer", (Throwable)exception);
        }
        return outputStreamWriter;
    }

    private void tryCloseWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                logger.e("Unable to close writer for records file", iOException);
            }
        }
    }

    private File deleteAllRecords() {
        File file = this.fileManager.createDirectory("KinesisRecorder");
        if (!this.recordFile.delete()) {
            logger.e("Failed to delete records file that exceeds the max storage size");
        }
        try {
            this.recordFile = this.fileManager.createFile(new File(file, "KinesisRecords"));
        }
        catch (IOException iOException) {
            logger.e("An error occurred while attempting to create the records file", iOException);
        }
        return this.recordFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File deleteReadRecords(int n) {
        File file = this.fileManager.createDirectory("KinesisRecorder");
        File file2 = null;
        try {
            File file3 = new File(file, "KinesisRecords.tmp");
            if (file3.exists() && !file3.delete()) {
                logger.e("Failed to delete previous temp file");
            }
            file2 = this.fileManager.createFile(file3);
        }
        catch (IOException iOException) {
            logger.e("An error occurred while attempting to create/open the temporary records file", iOException);
            return this.recordFile;
        }
        boolean bl = false;
        if (file2 != null && this.recordFile.exists() && file2.exists()) {
            Object object;
            BufferedReader bufferedReader = null;
            PrintWriter printWriter = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(this.recordFile));
                printWriter = new PrintWriter(new FileWriter(file2, true));
                object = null;
                int n2 = 0;
                while ((object = bufferedReader.readLine()) != null) {
                    if (++n2 <= n) continue;
                    printWriter.println((String)object);
                    printWriter.flush();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl = true;
                logger.e("The records file count not be found", fileNotFoundException);
            }
            catch (IOException iOException) {
                logger.e("An error occurred while attempting to delete the read records", iOException);
                bl = true;
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!bl) {
                    if (this.recordFile.delete()) {
                        if (!file2.renameTo(this.recordFile)) {
                            logger.e("Failed to rename temp file to records file");
                        }
                        try {
                            this.recordFile = this.fileManager.createFile(new File(file, "KinesisRecords"));
                        }
                        catch (IOException iOException) {
                            logger.e("An error occurred while attempting to create the recordsFile", iOException);
                        }
                    } else {
                        logger.e("Failed to delete previous records file");
                    }
                }
            }
            object = new File(file, "KinesisRecords.tmp");
            if (((File)object).exists() && !((File)object).delete()) {
                logger.e("Failed to delete temp file");
            }
        }
        return this.recordFile;
    }

    @Override
    public RecordStore.RecordIterator iterator() {
        return new RecordStore.RecordIterator(){
            int linesRead = 0;
            String nextBuffer = null;
            BufferedReader reader = null;
            boolean isEndOfFile = false;

            private boolean tryOpenReader() {
                if (this.reader != null) {
                    return true;
                }
                if (!this.isEndOfFile) {
                    InputStreamReader inputStreamReader = null;
                    try {
                        inputStreamReader = new InputStreamReader(FileRecordStore.this.fileManager.newInputStream(FileRecordStore.this.recordFile));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        logger.e("Could not open the records file", fileNotFoundException);
                    }
                    if (inputStreamReader != null) {
                        this.reader = new BufferedReader(inputStreamReader);
                        return true;
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void tryCloseReader() {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        logger.e("Unable to close reader for records file", iOException);
                    }
                    finally {
                        this.reader = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                boolean bl = false;
                FileRecordStore.this.accessLock.lock();
                try {
                    boolean bl2;
                    if (this.nextBuffer != null) {
                        bl = true;
                    } else {
                        if (!this.tryOpenReader()) {
                            boolean bl3 = bl;
                            return bl3;
                        }
                        bl2 = false;
                        while (!bl2) {
                            try {
                                this.nextBuffer = this.reader.readLine();
                                bl2 = true;
                            }
                            catch (IOException iOException) {
                                this.nextBuffer = null;
                                bl2 = true;
                            }
                        }
                        if (this.nextBuffer != null) {
                            bl = true;
                        } else {
                            this.isEndOfFile = true;
                            this.tryCloseReader();
                        }
                    }
                    bl2 = bl;
                    return bl2;
                }
                finally {
                    FileRecordStore.this.accessLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String next() {
                String string = null;
                FileRecordStore.this.accessLock.lock();
                try {
                    if (this.nextBuffer != null) {
                        string = this.nextBuffer;
                        ++this.linesRead;
                        this.nextBuffer = null;
                    } else {
                        if (!this.tryOpenReader()) {
                            String string2 = string;
                            return string2;
                        }
                        boolean bl = false;
                        while (!bl) {
                            try {
                                string = this.reader.readLine();
                                bl = true;
                            }
                            catch (IOException iOException) {
                                string = null;
                                bl = true;
                            }
                        }
                        if (string != null) {
                            ++this.linesRead;
                        } else {
                            this.isEndOfFile = true;
                            this.tryCloseReader();
                        }
                    }
                    String string3 = string;
                    return string3;
                }
                finally {
                    FileRecordStore.this.accessLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String peek() {
                FileRecordStore.this.accessLock.lock();
                try {
                    this.hasNext();
                    String string = this.nextBuffer;
                    return string;
                }
                finally {
                    FileRecordStore.this.accessLock.unlock();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove() operation is not supported for this iterator");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeReadRecords() {
                FileRecordStore.this.accessLock.lock();
                try {
                    FileRecordStore.this.deleteReadRecords(this.linesRead);
                    this.resetReader();
                }
                finally {
                    FileRecordStore.this.accessLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAllRecords() {
                FileRecordStore.this.accessLock.lock();
                try {
                    FileRecordStore.this.deleteAllRecords();
                    this.resetReader();
                }
                finally {
                    FileRecordStore.this.accessLock.unlock();
                }
            }

            private void resetReader() {
                this.tryCloseReader();
                this.linesRead = 0;
                this.nextBuffer = null;
            }
        };
    }
}

