/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal;

import android.util.Base64;
import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.Logger;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONRecordAdapter {
    private static Logger logger = Logger.getLogger(JSONRecordAdapter.class);
    private static final String DATA_FIELD_KEY = "Data";
    private static final String STREAM_NAME_FIELD = "StreamName";
    private static final String PARTITION_KEY_FIELD = "PartitionKey";
    private static final String EXPLICIT_HASH_FIELD = "ExplicitHash";
    private static final String SEQUENCE_NUMBER_FIELD = "SequenceNumber";

    public static ByteBuffer getData(JSONObject jSONObject) throws JSONException {
        return ByteBuffer.wrap(Base64.decode((String)jSONObject.getString(DATA_FIELD_KEY), (int)0));
    }

    public static String getPartitionKey(JSONObject jSONObject) throws JSONException {
        return jSONObject.getString(PARTITION_KEY_FIELD);
    }

    public static String getStreamName(JSONObject jSONObject) throws JSONException {
        return jSONObject.getString(STREAM_NAME_FIELD);
    }

    public JSONObject translateFromRecord(PutRecordRequest putRecordRequest) {
        if (null == putRecordRequest) {
            logger.i("The Record provided was null");
            return null;
        }
        if (putRecordRequest.getData() == null || putRecordRequest.getPartitionKey() == null || putRecordRequest.getPartitionKey().isEmpty() || putRecordRequest.getStreamName() == null || putRecordRequest.getStreamName().isEmpty()) {
            throw new AmazonClientException("RecordRequests must specify a partition key, stream name, and data");
        }
        if (!putRecordRequest.getData().hasArray()) {
            throw new AmazonClientException("ByteBuffer must be based on array for proper storage");
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(DATA_FIELD_KEY, (Object)Base64.encodeToString((byte[])putRecordRequest.getData().array(), (int)0));
            jSONObject.put(STREAM_NAME_FIELD, (Object)putRecordRequest.getStreamName());
            jSONObject.put(PARTITION_KEY_FIELD, (Object)putRecordRequest.getPartitionKey());
            jSONObject.putOpt(EXPLICIT_HASH_FIELD, (Object)putRecordRequest.getExplicitHashKey());
            jSONObject.putOpt(SEQUENCE_NUMBER_FIELD, (Object)putRecordRequest.getSequenceNumberForOrdering());
        }
        catch (JSONException jSONException) {
            throw new AmazonClientException("Unable to convert KinesisRecord to JSON " + jSONException.getMessage());
        }
        return jSONObject;
    }
}

