/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging;

import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.LogInitializer;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.appender.DeveloperLogCatAppender;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.appender.LogAppender;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Logger {
    public static final String TAG = "KinesisBatcher";
    private static LogLevel globalLevel = LogLevel.WARN;
    private static Map<Class<?>, LogAppender> appenders = new ConcurrentHashMap();
    private static Map<Class<?>, Logger> loggers = new ConcurrentHashMap();
    private LogLevel classLevel = null;
    private Class<?> cls = null;
    private String tag = "KinesisBatcher";
    private static boolean initialized = false;

    public Logger(String string, Class<?> clazz) {
        assert (clazz != null);
        this.cls = clazz;
        this.tag = string;
    }

    public synchronized boolean isLoggingEnabled(LogLevel logLevel) {
        boolean bl = false;
        if (logLevel.compareTo(this.getLogLevel()) >= 0) {
            bl = true;
        }
        return bl;
    }

    synchronized LogLevel getLogLevel() {
        LogLevel logLevel = LogLevel.OFF;
        logLevel = null != this.classLevel ? this.classLevel : Logger.getGlobalLevel();
        return logLevel;
    }

    public static synchronized void setGlobalLevel(LogLevel logLevel) {
        globalLevel = logLevel;
    }

    public static LogLevel getGlobalLevel() {
        return globalLevel;
    }

    public synchronized void setLevel(LogLevel logLevel) {
        this.classLevel = logLevel;
    }

    public static void attachLogAppender(LogAppender logAppender) {
        Logger.attachAppender(logAppender);
    }

    public static void detachLogAppender(LogAppender logAppender) {
        Logger.detachAppender(logAppender);
    }

    public static Collection<LogAppender> getLogAppenders() {
        return Logger.getAppenders();
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getClassLogger(clazz);
    }

    static synchronized Logger getClassLogger(Class<?> clazz) {
        if (null == clazz) {
            clazz = Logger.class;
        }
        if (loggers.containsKey(clazz)) {
            return loggers.get(clazz);
        }
        Logger logger = new Logger(TAG, clazz);
        loggers.put(clazz, logger);
        return logger;
    }

    public static void attachAppender(LogAppender logAppender) {
        if (null == logAppender) {
            return;
        }
        if (!appenders.containsKey(logAppender.getClass())) {
            appenders.put(logAppender.getClass(), logAppender);
        }
    }

    public static void detachAppender(LogAppender logAppender) {
        if (null == logAppender) {
            return;
        }
        if (appenders.containsKey(logAppender.getClass())) {
            appenders.remove(logAppender.getClass());
        }
    }

    public static Collection<LogAppender> getAppenders() {
        return appenders.values();
    }

    Class<?> getLogClass() {
        return this.cls;
    }

    String getTag() {
        return this.tag;
    }

    public void d(String string) {
        if (this.isLoggingEnabled(LogLevel.DEBUG)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.d(this.getTag(), logAppender.decorateMessage(this.cls, string));
            }
        }
    }

    public void d(String string, Throwable throwable) {
        if (this.isLoggingEnabled(LogLevel.DEBUG)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.d(this.getTag(), logAppender.decorateMessage(this.cls, string), throwable);
            }
        }
    }

    public void devd(String string) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devd(this.getTag(), logAppender.decorateMessage(this.cls, string));
        }
    }

    public void devd(String string, Throwable throwable) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devd(this.getTag(), logAppender.decorateMessage(this.cls, string), throwable);
        }
    }

    public void v(String string) {
        if (this.isLoggingEnabled(LogLevel.VERBOSE)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.v(this.getTag(), logAppender.decorateMessage(this.cls, string));
            }
        }
    }

    public void v(String string, Throwable throwable) {
        if (this.isLoggingEnabled(LogLevel.VERBOSE)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.v(this.getTag(), logAppender.decorateMessage(this.cls, string), throwable);
            }
        }
    }

    public void devv(String string) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devv(this.getTag(), logAppender.decorateMessage(this.cls, string));
        }
    }

    public void devv(String string, Throwable throwable) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devv(this.getTag(), logAppender.decorateMessage(this.cls, string), throwable);
        }
    }

    public void i(String string) {
        if (this.isLoggingEnabled(LogLevel.INFO)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.i(this.getTag(), logAppender.decorateMessage(this.cls, string));
            }
        }
    }

    public void i(String string, Throwable throwable) {
        if (this.isLoggingEnabled(LogLevel.INFO)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.i(this.getTag(), logAppender.decorateMessage(this.cls, string), throwable);
            }
        }
    }

    public void devi(String string) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devi(this.getTag(), logAppender.decorateMessage(this.cls, string));
        }
    }

    public void devi(String string, Throwable throwable) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devi(this.getTag(), logAppender.decorateMessage(this.cls, string), throwable);
        }
    }

    public void w(String string) {
        if (this.isLoggingEnabled(LogLevel.WARN)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.w(this.getTag(), logAppender.decorateMessage(this.cls, string));
            }
        }
    }

    public void w(Throwable throwable) {
        if (this.isLoggingEnabled(LogLevel.WARN)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.w(this.getTag(), throwable);
            }
        }
    }

    public void w(String string, Throwable throwable) {
        if (this.isLoggingEnabled(LogLevel.WARN)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.w(this.getTag(), logAppender.decorateMessage(this.cls, string), throwable);
            }
        }
    }

    public void devw(String string) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devw(this.getTag(), logAppender.decorateMessage(this.cls, string));
        }
    }

    public void devw(Throwable throwable) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devw(this.getTag(), throwable);
        }
    }

    public void devw(String string, Throwable throwable) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.devw(this.getTag(), logAppender.decorateMessage(this.cls, string), throwable);
        }
    }

    public void e(String string) {
        if (this.isLoggingEnabled(LogLevel.ERROR)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.e(this.tag, logAppender.decorateMessage(this.cls, string));
            }
        }
    }

    public void e(String string, Throwable throwable) {
        if (this.isLoggingEnabled(LogLevel.ERROR)) {
            for (LogAppender logAppender : Logger.getLogAppenders()) {
                logAppender.e(this.tag, logAppender.decorateMessage(this.cls, string), throwable);
            }
        }
    }

    public void deve(String string) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.deve(this.tag, logAppender.decorateMessage(this.cls, string));
        }
    }

    public void deve(String string, Throwable throwable) {
        for (LogAppender logAppender : Logger.getLogAppenders()) {
            logAppender.deve(this.tag, logAppender.decorateMessage(this.cls, string), throwable);
        }
    }

    public static synchronized void tryInitialize() {
        if (!initialized) {
            Logger.tryInitialize(new LogInitializer(){

                @Override
                public void tryInitialize() {
                    Logger.setGlobalLevel(LogLevel.WARN);
                    Logger.attachAppender(new DeveloperLogCatAppender());
                }
            });
        }
    }

    public static synchronized void tryInitialize(LogInitializer logInitializer) {
        if (!initialized && logInitializer != null) {
            logInitializer.tryInitialize();
            initialized = true;
        }
    }

    public static enum LogLevel {
        VERBOSE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

