/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetRecordsResult
implements Serializable {
    private ListWithAutoConstructFlag<Record> records;
    private String nextShardIterator;

    public List<Record> getRecords() {
        if (this.records == null) {
            this.records = new ListWithAutoConstructFlag();
            this.records.setAutoConstruct(true);
        }
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        ListWithAutoConstructFlag recordsCopy = new ListWithAutoConstructFlag(records.size());
        recordsCopy.addAll(records);
        this.records = recordsCopy;
    }

    public GetRecordsResult withRecords(Record ... records) {
        if (this.getRecords() == null) {
            this.setRecords(new ArrayList<Record>(records.length));
        }
        for (Record value : records) {
            this.getRecords().add(value);
        }
        return this;
    }

    public GetRecordsResult withRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
        } else {
            ListWithAutoConstructFlag recordsCopy = new ListWithAutoConstructFlag(records.size());
            recordsCopy.addAll(records);
            this.records = recordsCopy;
        }
        return this;
    }

    public String getNextShardIterator() {
        return this.nextShardIterator;
    }

    public void setNextShardIterator(String nextShardIterator) {
        this.nextShardIterator = nextShardIterator;
    }

    public GetRecordsResult withNextShardIterator(String nextShardIterator) {
        this.nextShardIterator = nextShardIterator;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecords() != null) {
            sb.append("Records: " + this.getRecords() + ",");
        }
        if (this.getNextShardIterator() != null) {
            sb.append("NextShardIterator: " + this.getNextShardIterator());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : ((Object)this.getRecords()).hashCode());
        hashCode = 31 * hashCode + (this.getNextShardIterator() == null ? 0 : this.getNextShardIterator().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResult)) {
            return false;
        }
        GetRecordsResult other = (GetRecordsResult)obj;
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (other.getRecords() != null && !((Object)other.getRecords()).equals(this.getRecords())) {
            return false;
        }
        if (other.getNextShardIterator() == null ^ this.getNextShardIterator() == null) {
            return false;
        }
        return other.getNextShardIterator() == null || other.getNextShardIterator().equals(this.getNextShardIterator());
    }
}

