/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveTagsFromStreamRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String streamName;
    private ListWithAutoConstructFlag<String> tagKeys;

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public RemoveTagsFromStreamRequest withStreamName(String streamName) {
        this.streamName = streamName;
        return this;
    }

    public List<String> getTagKeys() {
        if (this.tagKeys == null) {
            this.tagKeys = new ListWithAutoConstructFlag();
            this.tagKeys.setAutoConstruct(true);
        }
        return this.tagKeys;
    }

    public void setTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
            return;
        }
        ListWithAutoConstructFlag tagKeysCopy = new ListWithAutoConstructFlag(tagKeys.size());
        tagKeysCopy.addAll(tagKeys);
        this.tagKeys = tagKeysCopy;
    }

    public RemoveTagsFromStreamRequest withTagKeys(String ... tagKeys) {
        if (this.getTagKeys() == null) {
            this.setTagKeys(new ArrayList<String>(tagKeys.length));
        }
        for (String value : tagKeys) {
            this.getTagKeys().add(value);
        }
        return this;
    }

    public RemoveTagsFromStreamRequest withTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
        } else {
            ListWithAutoConstructFlag tagKeysCopy = new ListWithAutoConstructFlag(tagKeys.size());
            tagKeysCopy.addAll(tagKeys);
            this.tagKeys = tagKeysCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamName() != null) {
            sb.append("StreamName: " + this.getStreamName() + ",");
        }
        if (this.getTagKeys() != null) {
            sb.append("TagKeys: " + this.getTagKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getTagKeys() == null ? 0 : ((Object)this.getTagKeys()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromStreamRequest)) {
            return false;
        }
        RemoveTagsFromStreamRequest other = (RemoveTagsFromStreamRequest)obj;
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        if (other.getStreamName() != null && !other.getStreamName().equals(this.getStreamName())) {
            return false;
        }
        if (other.getTagKeys() == null ^ this.getTagKeys() == null) {
            return false;
        }
        return other.getTagKeys() == null || ((Object)other.getTagKeys()).equals(this.getTagKeys());
    }
}

