/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.ListShardsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;

public class ListShardsRequestMarshaller
implements Marshaller<Request<ListShardsRequest>, ListShardsRequest> {
    public Request<ListShardsRequest> marshall(ListShardsRequest listShardsRequest) {
        if (listShardsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListShardsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listShardsRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.ListShards";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (listShardsRequest.getStreamName() != null) {
                String streamName = listShardsRequest.getStreamName();
                jsonWriter.name("StreamName");
                jsonWriter.value(streamName);
            }
            if (listShardsRequest.getNextToken() != null) {
                String nextToken = listShardsRequest.getNextToken();
                jsonWriter.name("NextToken");
                jsonWriter.value(nextToken);
            }
            if (listShardsRequest.getExclusiveStartShardId() != null) {
                String exclusiveStartShardId = listShardsRequest.getExclusiveStartShardId();
                jsonWriter.name("ExclusiveStartShardId");
                jsonWriter.value(exclusiveStartShardId);
            }
            if (listShardsRequest.getMaxResults() != null) {
                Integer maxResults = listShardsRequest.getMaxResults();
                jsonWriter.name("MaxResults");
                jsonWriter.value((Number)maxResults);
            }
            if (listShardsRequest.getStreamCreationTimestamp() != null) {
                Date streamCreationTimestamp = listShardsRequest.getStreamCreationTimestamp();
                jsonWriter.name("StreamCreationTimestamp");
                jsonWriter.value(streamCreationTimestamp);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

