/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class PutRecordRequestMarshaller
implements Marshaller<Request<PutRecordRequest>, PutRecordRequest> {
    public Request<PutRecordRequest> marshall(PutRecordRequest putRecordRequest) {
        if (putRecordRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRecordRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.PutRecord";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, 8192);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gos, StringUtils.UTF8);
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)writer);
            jsonWriter.beginObject();
            if (putRecordRequest.getStreamName() != null) {
                jsonWriter.name("StreamName").value(putRecordRequest.getStreamName());
            }
            if (putRecordRequest.getData() != null) {
                jsonWriter.name("Data").value(putRecordRequest.getData());
            }
            if (putRecordRequest.getPartitionKey() != null) {
                jsonWriter.name("PartitionKey").value(putRecordRequest.getPartitionKey());
            }
            if (putRecordRequest.getExplicitHashKey() != null) {
                jsonWriter.name("ExplicitHashKey").value(putRecordRequest.getExplicitHashKey());
            }
            if (putRecordRequest.getSequenceNumberForOrdering() != null) {
                jsonWriter.name("SequenceNumberForOrdering").value(putRecordRequest.getSequenceNumberForOrdering());
            }
            jsonWriter.endObject();
            jsonWriter.flush();
            gos.finish();
            ((Writer)writer).close();
            byte[] content = baos.toByteArray();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
            request.addHeader("Content-Encoding", "gzip");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

