/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.EnhancedMetrics;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamDescription;
import com.amazonaws.services.kinesis.model.transform.EnhancedMetricsJsonMarshaller;
import com.amazonaws.services.kinesis.model.transform.ShardJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class StreamDescriptionJsonMarshaller {
    private static StreamDescriptionJsonMarshaller instance;

    StreamDescriptionJsonMarshaller() {
    }

    public void marshall(StreamDescription streamDescription, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (streamDescription.getStreamName() != null) {
            String streamName = streamDescription.getStreamName();
            jsonWriter.name("StreamName");
            jsonWriter.value(streamName);
        }
        if (streamDescription.getStreamARN() != null) {
            String streamARN = streamDescription.getStreamARN();
            jsonWriter.name("StreamARN");
            jsonWriter.value(streamARN);
        }
        if (streamDescription.getStreamStatus() != null) {
            String streamStatus = streamDescription.getStreamStatus();
            jsonWriter.name("StreamStatus");
            jsonWriter.value(streamStatus);
        }
        if (streamDescription.getShards() != null) {
            List<Shard> shards = streamDescription.getShards();
            jsonWriter.name("Shards");
            jsonWriter.beginArray();
            for (Shard shardsItem : shards) {
                if (shardsItem == null) continue;
                ShardJsonMarshaller.getInstance().marshall(shardsItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (streamDescription.getHasMoreShards() != null) {
            Boolean hasMoreShards = streamDescription.getHasMoreShards();
            jsonWriter.name("HasMoreShards");
            jsonWriter.value(hasMoreShards.booleanValue());
        }
        if (streamDescription.getRetentionPeriodHours() != null) {
            Integer retentionPeriodHours = streamDescription.getRetentionPeriodHours();
            jsonWriter.name("RetentionPeriodHours");
            jsonWriter.value((Number)retentionPeriodHours);
        }
        if (streamDescription.getStreamCreationTimestamp() != null) {
            Date streamCreationTimestamp = streamDescription.getStreamCreationTimestamp();
            jsonWriter.name("StreamCreationTimestamp");
            jsonWriter.value(streamCreationTimestamp);
        }
        if (streamDescription.getEnhancedMonitoring() != null) {
            List<EnhancedMetrics> enhancedMonitoring = streamDescription.getEnhancedMonitoring();
            jsonWriter.name("EnhancedMonitoring");
            jsonWriter.beginArray();
            for (EnhancedMetrics enhancedMonitoringItem : enhancedMonitoring) {
                if (enhancedMonitoringItem == null) continue;
                EnhancedMetricsJsonMarshaller.getInstance().marshall(enhancedMonitoringItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (streamDescription.getEncryptionType() != null) {
            String encryptionType = streamDescription.getEncryptionType();
            jsonWriter.name("EncryptionType");
            jsonWriter.value(encryptionType);
        }
        if (streamDescription.getKeyId() != null) {
            String keyId = streamDescription.getKeyId();
            jsonWriter.name("KeyId");
            jsonWriter.value(keyId);
        }
        jsonWriter.endObject();
    }

    public static StreamDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamDescriptionJsonMarshaller();
        }
        return instance;
    }
}

