/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.StreamDescription;
import com.amazonaws.services.kinesis.model.transform.EnhancedMetricsJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.ShardJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class StreamDescriptionJsonUnmarshaller
implements Unmarshaller<StreamDescription, JsonUnmarshallerContext> {
    private static StreamDescriptionJsonUnmarshaller instance;

    StreamDescriptionJsonUnmarshaller() {
    }

    public StreamDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        StreamDescription streamDescription = new StreamDescription();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("StreamName")) {
                streamDescription.setStreamName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("StreamARN")) {
                streamDescription.setStreamARN(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("StreamStatus")) {
                streamDescription.setStreamStatus(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Shards")) {
                streamDescription.setShards(new ListUnmarshaller((Unmarshaller)ShardJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("HasMoreShards")) {
                streamDescription.setHasMoreShards(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RetentionPeriodHours")) {
                streamDescription.setRetentionPeriodHours(SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("StreamCreationTimestamp")) {
                streamDescription.setStreamCreationTimestamp(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EnhancedMonitoring")) {
                streamDescription.setEnhancedMonitoring(new ListUnmarshaller((Unmarshaller)EnhancedMetricsJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("EncryptionType")) {
                streamDescription.setEncryptionType(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("KeyId")) {
                streamDescription.setKeyId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return streamDescription;
    }

    public static StreamDescriptionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StreamDescriptionJsonUnmarshaller();
        }
        return instance;
    }
}

