/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal;

import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisRecorderConfig;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.FileManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;

public class FileRecordStore {
    private static final String TAG = "FileRecordStore";
    private final ReentrantLock accessLock = new ReentrantLock(true);
    private File recordFile;
    private FileManager fileManager;
    private KinesisRecorderConfig config;

    public FileRecordStore(File recorderDirectory, KinesisRecorderConfig config) throws IOException {
        this.fileManager = new FileManager(recorderDirectory);
        this.config = config;
        this.tryCreateRecordsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String record) throws IOException {
        boolean success = false;
        BufferedWriter writer = null;
        this.accessLock.lock();
        try {
            writer = this.tryInitializeWriter();
            if (writer != null) {
                if (this.recordFile.length() + (long)record.getBytes().length <= this.config.getMaxStorageSize()) {
                    writer.write(record);
                    writer.newLine();
                    writer.flush();
                    success = true;
                } else {
                    Log.e((String)TAG, (String)("The record file exceeded its allowed size of " + this.config.getMaxStorageSize() + " bytes"));
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            this.accessLock.unlock();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCreateRecordsFile() throws IOException {
        if (this.recordFile != null && this.recordFile.exists()) {
            return;
        }
        FileRecordStore fileRecordStore = this;
        synchronized (fileRecordStore) {
            if (this.recordFile != null && this.recordFile.exists()) {
                return;
            }
            File recordDir = this.fileManager.createDirectory("KinesisRecorder");
            this.recordFile = this.fileManager.createFile(new File(recordDir, "KinesisRecords"));
        }
    }

    private BufferedWriter tryInitializeWriter() throws IOException {
        BufferedWriter writer = null;
        this.tryCreateRecordsFile();
        OutputStream stream = this.fileManager.newOutputStream(this.recordFile, true);
        writer = new BufferedWriter(new OutputStreamWriter(stream));
        return writer;
    }

    private File deleteAllRecords() throws IOException {
        File recordsDir = this.fileManager.createDirectory("KinesisRecorder");
        this.recordFile.delete();
        this.recordFile = this.fileManager.createFile(new File(recordsDir, "KinesisRecords"));
        return this.recordFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File deleteReadRecords(int lineNumber) throws IOException {
        File recordsDir = this.fileManager.createDirectory("KinesisRecorder");
        File tempRecordsFile = null;
        File tempFile = new File(recordsDir, "KinesisRecords.tmp");
        if (tempFile.exists() && !tempFile.delete()) {
            throw new IOException("Failed to delete previous temp file");
        }
        tempRecordsFile = this.fileManager.createFile(tempFile);
        if (tempRecordsFile != null && this.recordFile.exists() && tempRecordsFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                reader = new BufferedReader(new FileReader(this.recordFile));
                writer = new PrintWriter(new FileWriter(tempRecordsFile, true));
                String line = null;
                int currentLineNumber = 0;
                while ((line = reader.readLine()) != null) {
                    if (++currentLineNumber <= lineNumber) continue;
                    writer.println(line);
                    writer.flush();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
                if (!this.recordFile.delete() || !tempRecordsFile.renameTo(this.recordFile)) {
                    throw new IOException("Failed to delete read records and persist unread records");
                }
            }
            if (tempFile.exists() && !tempFile.delete()) {
                Log.e((String)TAG, (String)"Failed to delete temp file");
            }
        }
        return this.recordFile;
    }

    public RecordIterator iterator() {
        return new RecordIterator();
    }

    public class RecordIterator
    implements Iterator<String> {
        int linesRead = 0;
        String nextBuffer = null;
        BufferedReader reader = null;
        boolean isEndOfFile = false;

        private boolean tryOpenReader() throws FileNotFoundException {
            if (this.reader != null) {
                return true;
            }
            if (!this.isEndOfFile) {
                InputStreamReader streamReader = null;
                streamReader = new InputStreamReader(FileRecordStore.this.fileManager.newInputStream(FileRecordStore.this.recordFile));
                if (streamReader != null) {
                    this.reader = new BufferedReader(streamReader);
                    return true;
                }
            }
            return false;
        }

        private void tryCloseReader() throws IOException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = false;
            FileRecordStore.this.accessLock.lock();
            try {
                boolean found;
                if (this.nextBuffer != null) {
                    hasNext = true;
                } else {
                    if (!this.tryOpenReader()) {
                        boolean bl = hasNext;
                        return bl;
                    }
                    found = false;
                    while (!found) {
                        try {
                            this.nextBuffer = this.reader.readLine();
                            found = true;
                        }
                        catch (IOException e) {
                            this.nextBuffer = null;
                            found = true;
                        }
                    }
                    if (this.nextBuffer != null) {
                        hasNext = true;
                    } else {
                        this.isEndOfFile = true;
                        this.tryCloseReader();
                    }
                }
                found = hasNext;
                return found;
            }
            catch (FileNotFoundException fnfe) {
                throw new AmazonClientException("Cannot find records file", (Throwable)fnfe);
            }
            catch (IOException ioe) {
                throw new AmazonClientException("IO Error", (Throwable)ioe);
            }
            finally {
                FileRecordStore.this.accessLock.unlock();
            }
        }

        @Override
        public String next() {
            String next = null;
            FileRecordStore.this.accessLock.lock();
            try {
                if (this.nextBuffer != null) {
                    next = this.nextBuffer;
                    ++this.linesRead;
                    this.nextBuffer = null;
                } else {
                    if (!this.tryOpenReader()) {
                        String string = next;
                        return string;
                    }
                    boolean found = false;
                    while (!found) {
                        try {
                            next = this.reader.readLine();
                            found = true;
                        }
                        catch (IOException e) {
                            next = null;
                            found = true;
                        }
                    }
                    if (next != null) {
                        ++this.linesRead;
                    } else {
                        this.isEndOfFile = true;
                        this.tryCloseReader();
                    }
                }
                String found = next;
                return found;
            }
            catch (FileNotFoundException e) {
                throw new AmazonClientException("Cannot find records file", (Throwable)e);
            }
            catch (IOException ioe) {
                throw new AmazonClientException("IO Error", (Throwable)ioe);
            }
            finally {
                FileRecordStore.this.accessLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String peek() {
            FileRecordStore.this.accessLock.lock();
            try {
                this.hasNext();
                String string = this.nextBuffer;
                return string;
            }
            finally {
                FileRecordStore.this.accessLock.unlock();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove() operation is not supported for this iterator");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeReadRecords() throws IOException {
            FileRecordStore.this.accessLock.lock();
            try {
                FileRecordStore.this.deleteReadRecords(this.linesRead);
                this.resetReader();
            }
            finally {
                FileRecordStore.this.accessLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllRecords() throws IOException {
            FileRecordStore.this.accessLock.lock();
            try {
                FileRecordStore.this.deleteAllRecords();
                this.resetReader();
            }
            finally {
                FileRecordStore.this.accessLock.unlock();
            }
        }

        private void resetReader() throws IOException {
            this.tryCloseReader();
            this.linesRead = 0;
            this.nextBuffer = null;
        }
    }
}

