/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal;

import android.util.Base64;
import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONRecordAdapter {
    private static final String TAG = "JSONRecordAdapter";
    static final String DATA_FIELD_KEY = "Data";
    static final String STREAM_NAME_FIELD = "StreamName";
    static final String PARTITION_KEY_FIELD = "PartitionKey";
    static final String EXPLICIT_HASH_FIELD = "ExplicitHash";
    static final String SEQUENCE_NUMBER_FIELD = "SequenceNumber";

    public static ByteBuffer getData(JSONObject jsonObject) throws JSONException {
        return ByteBuffer.wrap(Base64.decode((String)jsonObject.getString(DATA_FIELD_KEY), (int)0));
    }

    public static String getPartitionKey(JSONObject jsonObject) throws JSONException {
        return jsonObject.getString(PARTITION_KEY_FIELD);
    }

    public static String getStreamName(JSONObject jsonObject) throws JSONException {
        return jsonObject.getString(STREAM_NAME_FIELD);
    }

    public JSONObject translateFromRecord(PutRecordRequest source) {
        if (null == source) {
            Log.w((String)TAG, (String)"The Record provided was null");
            return null;
        }
        if (source.getData() == null || source.getPartitionKey() == null || source.getPartitionKey().isEmpty() || source.getStreamName() == null || source.getStreamName().isEmpty()) {
            throw new AmazonClientException("RecordRequests must specify a partition key, stream name, and data");
        }
        if (!source.getData().hasArray()) {
            throw new AmazonClientException("ByteBuffer must be based on array for proper storage");
        }
        JSONObject recordJson = new JSONObject();
        try {
            recordJson.put(DATA_FIELD_KEY, (Object)Base64.encodeToString((byte[])source.getData().array(), (int)0));
            recordJson.put(STREAM_NAME_FIELD, (Object)source.getStreamName());
            recordJson.put(PARTITION_KEY_FIELD, (Object)source.getPartitionKey());
            recordJson.putOpt(EXPLICIT_HASH_FIELD, (Object)source.getExplicitHashKey());
            recordJson.putOpt(SEQUENCE_NUMBER_FIELD, (Object)source.getSequenceNumberForOrdering());
        }
        catch (JSONException e) {
            throw new AmazonClientException("Unable to convert KinesisRecord to JSON " + e.getMessage());
        }
        return recordJson;
    }
}

