/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kinesisfirehose.model.PutRecordBatchRequest;
import com.amazonaws.services.kinesisfirehose.model.Record;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class PutRecordBatchRequestMarshaller
implements Marshaller<Request<PutRecordBatchRequest>, PutRecordBatchRequest> {
    public Request<PutRecordBatchRequest> marshall(PutRecordBatchRequest putRecordBatchRequest) {
        if (putRecordBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRecordBatchRequest, "AWSKinesisFirehose");
        String target = "Firehose_20150804.PutRecordBatch";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag recordsList;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, 8192);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gos, StringUtils.UTF8);
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)writer);
            jsonWriter.beginObject();
            if (putRecordBatchRequest.getDeliveryStreamName() != null) {
                jsonWriter.name("DeliveryStreamName").value(putRecordBatchRequest.getDeliveryStreamName());
            }
            if (!((recordsList = (ListWithAutoConstructFlag)putRecordBatchRequest.getRecords()) == null || recordsList.isAutoConstruct() && recordsList.isEmpty())) {
                jsonWriter.name("Records");
                jsonWriter.beginArray();
                for (Record recordsListValue : recordsList) {
                    if (recordsListValue == null) continue;
                    jsonWriter.beginObject();
                    if (recordsListValue.getData() != null) {
                        jsonWriter.name("Data").value(recordsListValue.getData());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.flush();
            gos.finish();
            ((Writer)writer).close();
            byte[] content = baos.toByteArray();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
            request.addHeader("Content-Encoding", "gzip");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

