/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.transform.HashKeyRangeJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.SequenceNumberRangeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

public class ShardJsonUnmarshaller
implements Unmarshaller<Shard, JsonUnmarshallerContext> {
    private static ShardJsonUnmarshaller instance;

    public Shard unmarshall(JsonUnmarshallerContext context) throws Exception {
        Shard shard = new Shard();
        AwsJsonReader reader = context.getReader();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("ShardId")) {
                shard.setShardId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ParentShardId")) {
                shard.setParentShardId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("AdjacentParentShardId")) {
                shard.setAdjacentParentShardId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("HashKeyRange")) {
                shard.setHashKeyRange(HashKeyRangeJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("SequenceNumberRange")) {
                shard.setSequenceNumberRange(SequenceNumberRangeJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return shard;
    }

    public static ShardJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ShardJsonUnmarshaller();
        }
        return instance;
    }
}

