/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.FileRecordParser;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.FileRecordStore;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisRecorderConfig;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.RecordSender;
import com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractKinesisRecorder {
    private static final Log LOGGER = LogFactory.getLog(AbstractKinesisRecorder.class);
    private static final int MAX_RETRY_COUNT = 3;
    private static final int MAX_RECORDS_PER_BATCH = 128;
    private static final int MAX_BATCH_RECORDS_SIZE_BYTES = 524288;
    protected KinesisRecorderConfig config;
    protected FileRecordStore recordStore;

    protected abstract RecordSender getRecordSender();

    protected AbstractKinesisRecorder(FileRecordStore recordStore, KinesisRecorderConfig config) {
        if (recordStore == null) {
            throw new IllegalArgumentException("Record store can't be null");
        }
        this.recordStore = recordStore;
        this.config = config;
    }

    public void saveRecord(String data, String streamName) {
        this.saveRecord(data.getBytes(StringUtils.UTF8), streamName);
    }

    public void saveRecord(byte[] data, String streamName) {
        try {
            this.recordStore.put(FileRecordParser.asString(streamName, data));
        }
        catch (IOException e) {
            throw new AmazonClientException("Error saving record", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void submitAllRecords() {
        RecordSender sender = this.getRecordSender();
        FileRecordStore.RecordIterator iterator = this.recordStore.iterator();
        ArrayList<byte[]> data = new ArrayList<byte[]>(128);
        int retry = 0;
        int count = 0;
        try {
            String streamName;
            while (iterator.hasNext() && retry < 3 && (streamName = this.nextBatch(iterator, data, 128, 524288)) != null && !data.isEmpty()) {
                try {
                    List<byte[]> failures = sender.sendBatch(streamName, data);
                    int successCount = data.size() - failures.size();
                    count += successCount;
                    iterator.removeReadRecords();
                    if (successCount == 0) {
                        ++retry;
                    }
                    if (failures.isEmpty()) continue;
                    for (byte[] bytes : failures) {
                        this.saveRecord(bytes, streamName);
                    }
                }
                catch (AmazonClientException ace) {
                    if (sender.isRecoverable(ace)) {
                        LOGGER.error((Object)"ServiceException in submit all, the values of the data inside the requests appears valid.  The request will be kept", (Throwable)ace);
                        throw ace;
                    }
                    try {
                        iterator.removeReadRecords();
                    }
                    catch (IOException e) {
                        throw new AmazonClientException("Failed to drop bad records.", (Throwable)e);
                    }
                    LOGGER.error((Object)"ServiceException in submit all, the last request is presumed to be the cause and will be dropped", (Throwable)ace);
                    throw ace;
                }
                catch (IOException e) {
                    throw new AmazonClientException("Failed to remove read records", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            LOGGER.debug((Object)String.format("submitAllRecords sent %d records", count));
            try {
                iterator.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new AmazonClientException("Failed to close record file", (Throwable)e);
            }
        }
        LOGGER.debug((Object)String.format("submitAllRecords sent %d records", count));
        try {
            iterator.close();
            return;
        }
        catch (IOException e) {
            throw new AmazonClientException("Failed to close record file", (Throwable)e);
        }
    }

    protected String nextBatch(FileRecordStore.RecordIterator iterator, List<byte[]> data, int maxCount, int maxSize) {
        data.clear();
        String lastStreamName = null;
        int size = 0;
        int count = 0;
        FileRecordParser frp = new FileRecordParser();
        while (iterator.hasNext() && count < maxCount && size < maxSize) {
            String line = iterator.peek();
            if (line == null || line.isEmpty()) {
                iterator.next();
                continue;
            }
            try {
                frp.parse(line);
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to read line. Skip.", (Throwable)e);
                iterator.next();
                continue;
            }
            if (lastStreamName != null && !lastStreamName.equals(frp.streamName)) break;
            data.add(frp.bytes);
            ++count;
            size += frp.bytes.length;
            lastStreamName = frp.streamName;
            iterator.next();
        }
        return lastStreamName;
    }

    public KinesisRecorderConfig getKinesisRecorderConfig() {
        return this.config;
    }

    public long getDiskBytesUsed() {
        return this.recordStore.getFileSize();
    }

    public long getDiskByteLimit() {
        return this.config.getMaxStorageSize();
    }

    public synchronized void deleteAllRecords() {
        try {
            this.recordStore.iterator().removeAllRecords();
        }
        catch (IOException e) {
            throw new AmazonClientException("Error deleting events", (Throwable)e);
        }
    }
}

