/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import com.amazonaws.ClientConfiguration;

public class KinesisRecorderConfig {
    private static final long DEFAUT_MAX_STORAGE_SIZE = 0x500000L;
    private long maxStorageSize = 0x500000L;
    private final ClientConfiguration clientConfiguration;
    private String partitionKey;

    public KinesisRecorderConfig() {
        this(new ClientConfiguration());
    }

    public KinesisRecorderConfig(ClientConfiguration clientConfiguration) {
        if (clientConfiguration == null) {
            throw new IllegalArgumentException();
        }
        this.clientConfiguration = new ClientConfiguration(clientConfiguration);
    }

    public KinesisRecorderConfig(KinesisRecorderConfig other) {
        this.maxStorageSize = other.getMaxStorageSize();
        this.clientConfiguration = new ClientConfiguration(other.getClientConfiguration());
        this.partitionKey = other.partitionKey;
    }

    public KinesisRecorderConfig withPartitionKey(String partKey) {
        this.partitionKey = partKey;
        return this;
    }

    public KinesisRecorderConfig withMaxStorageSize(long maxStorage) {
        this.maxStorageSize = maxStorage;
        return this;
    }

    public long getMaxStorageSize() {
        return this.maxStorageSize;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }
}

