/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetRecordsRequestMarshaller
implements Marshaller<Request<GetRecordsRequest>, GetRecordsRequest> {
    public Request<GetRecordsRequest> marshall(GetRecordsRequest getRecordsRequest) {
        if (getRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetRecordsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getRecordsRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.GetRecords";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getRecordsRequest.getShardIterator() != null) {
                String shardIterator = getRecordsRequest.getShardIterator();
                jsonWriter.name("ShardIterator");
                jsonWriter.value(shardIterator);
            }
            if (getRecordsRequest.getLimit() != null) {
                Integer limit = getRecordsRequest.getLimit();
                jsonWriter.name("Limit");
                jsonWriter.value((Number)limit);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

