/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.RecordSender;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import com.amazonaws.services.kinesisfirehose.model.PutRecordBatchRequest;
import com.amazonaws.services.kinesisfirehose.model.PutRecordBatchResult;
import com.amazonaws.services.kinesisfirehose.model.Record;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class FirehoseRecordSender
implements RecordSender {
    private final AmazonKinesisFirehose client;
    private final String userAgent;

    public FirehoseRecordSender(AmazonKinesisFirehose client, String userAgent) {
        this.client = client;
        this.userAgent = userAgent;
    }

    @Override
    public List<byte[]> sendBatch(String streamName, List<byte[]> data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        PutRecordBatchRequest request = new PutRecordBatchRequest();
        request.setDeliveryStreamName(streamName);
        ArrayList<Record> records = new ArrayList<Record>(data.size());
        for (byte[] d : data) {
            Record r = new Record();
            r.setData(ByteBuffer.wrap(d));
            records.add(r);
        }
        request.setRecords(records);
        request.getRequestClientOptions().appendUserAgent(this.userAgent);
        PutRecordBatchResult result = this.client.putRecordBatch(request);
        int size = result.getRequestResponses().size();
        ArrayList<byte[]> failures = new ArrayList<byte[]>(result.getFailedPutCount());
        for (int i = 0; i < size; ++i) {
            if (result.getRequestResponses().get(i).getErrorCode() == null) continue;
            failures.add(data.get(i));
        }
        return failures;
    }

    @Override
    public boolean isRecoverable(AmazonClientException ace) {
        if (ace instanceof AmazonServiceException) {
            String errorCode = ((AmazonServiceException)ace).getErrorCode();
            return "InternalFailure".equals(errorCode) || "ServiceUnavailable".equals(errorCode) || "Throttling".equals(errorCode) || "ServiceUnavailableException".equals(errorCode);
        }
        return ace.getCause() != null && ace.getCause() instanceof IOException;
    }
}

