/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.AbstractKinesisRecorder;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.FileRecordStore;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.FirehoseRecordSender;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisRecorderConfig;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.RecordSender;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseClient;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.util.regex.Pattern;

public class KinesisFirehoseRecorder
extends AbstractKinesisRecorder {
    private static final String RECORD_FILE_NAME = "kinesis_firehose_records";
    private static final String USER_AGENT = KinesisFirehoseRecorder.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final int MAX_RECORD_SIZE_BYTES = 1024000;
    private static final Pattern STREAM_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]{1,64}");
    private FirehoseRecordSender sender;

    public KinesisFirehoseRecorder(File directory, Regions region, AWSCredentialsProvider credentialsProvider) {
        this(directory, region, credentialsProvider, new KinesisRecorderConfig());
    }

    public KinesisFirehoseRecorder(File directory, Regions region, AWSCredentialsProvider credentialsProvider, KinesisRecorderConfig config) {
        super(new FileRecordStore(directory, RECORD_FILE_NAME, config.getMaxStorageSize()), config);
        AmazonKinesisFirehoseClient client = new AmazonKinesisFirehoseClient(credentialsProvider, config.getClientConfiguration());
        client.setRegion(Region.getRegion((Regions)region));
        this.sender = new FirehoseRecordSender(client, USER_AGENT);
    }

    KinesisFirehoseRecorder(FirehoseRecordSender sender, FileRecordStore recordStore, KinesisRecorderConfig config) {
        super(recordStore, config);
        this.sender = sender;
    }

    @Override
    protected RecordSender getRecordSender() {
        return this.sender;
    }

    @Override
    public void saveRecord(byte[] data, String streamName) {
        if (streamName == null || !STREAM_NAME_PATTERN.matcher(streamName).matches()) {
            throw new IllegalArgumentException("Invalid stream name: " + streamName);
        }
        if (data == null || data.length == 0 || data.length > 1024000) {
            throw new IllegalArgumentException("Invalid data size.");
        }
        super.saveRecord(data, streamName);
    }
}

