/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.services.kinesis.model.Shard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListShardsResult
implements Serializable {
    private List<Shard> shards = new ArrayList<Shard>();
    private String nextToken;

    public List<Shard> getShards() {
        return this.shards;
    }

    public void setShards(Collection<Shard> shards) {
        if (shards == null) {
            this.shards = null;
            return;
        }
        this.shards = new ArrayList<Shard>(shards);
    }

    public ListShardsResult withShards(Shard ... shards) {
        if (this.getShards() == null) {
            this.shards = new ArrayList<Shard>(shards.length);
        }
        for (Shard value : shards) {
            this.shards.add(value);
        }
        return this;
    }

    public ListShardsResult withShards(Collection<Shard> shards) {
        this.setShards(shards);
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListShardsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getShards() != null) {
            sb.append("Shards: " + this.getShards() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getShards() == null ? 0 : this.getShards().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShardsResult)) {
            return false;
        }
        ListShardsResult other = (ListShardsResult)obj;
        if (other.getShards() == null ^ this.getShards() == null) {
            return false;
        }
        if (other.getShards() != null && !other.getShards().equals(this.getShards())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

