/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListTagsForStreamRequestMarshaller
implements Marshaller<Request<ListTagsForStreamRequest>, ListTagsForStreamRequest> {
    public Request<ListTagsForStreamRequest> marshall(ListTagsForStreamRequest listTagsForStreamRequest) {
        if (listTagsForStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListTagsForStreamRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTagsForStreamRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.ListTagsForStream";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (listTagsForStreamRequest.getStreamName() != null) {
                String streamName = listTagsForStreamRequest.getStreamName();
                jsonWriter.name("StreamName");
                jsonWriter.value(streamName);
            }
            if (listTagsForStreamRequest.getExclusiveStartTagKey() != null) {
                String exclusiveStartTagKey = listTagsForStreamRequest.getExclusiveStartTagKey();
                jsonWriter.name("ExclusiveStartTagKey");
                jsonWriter.value(exclusiveStartTagKey);
            }
            if (listTagsForStreamRequest.getLimit() != null) {
                Integer limit = listTagsForStreamRequest.getLimit();
                jsonWriter.name("Limit");
                jsonWriter.value((Number)limit);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

