/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.util.json.AwsJsonWriter;
import java.nio.ByteBuffer;
import java.util.Date;

class RecordJsonMarshaller {
    private static RecordJsonMarshaller instance;

    RecordJsonMarshaller() {
    }

    public void marshall(Record record, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (record.getSequenceNumber() != null) {
            String sequenceNumber = record.getSequenceNumber();
            jsonWriter.name("SequenceNumber");
            jsonWriter.value(sequenceNumber);
        }
        if (record.getApproximateArrivalTimestamp() != null) {
            Date approximateArrivalTimestamp = record.getApproximateArrivalTimestamp();
            jsonWriter.name("ApproximateArrivalTimestamp");
            jsonWriter.value(approximateArrivalTimestamp);
        }
        if (record.getData() != null) {
            ByteBuffer data = record.getData();
            jsonWriter.name("Data");
            jsonWriter.value(data);
        }
        if (record.getPartitionKey() != null) {
            String partitionKey = record.getPartitionKey();
            jsonWriter.name("PartitionKey");
            jsonWriter.value(partitionKey);
        }
        if (record.getEncryptionType() != null) {
            String encryptionType = record.getEncryptionType();
            jsonWriter.name("EncryptionType");
            jsonWriter.value(encryptionType);
        }
        jsonWriter.endObject();
    }

    public static RecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonMarshaller();
        }
        return instance;
    }
}

