/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.DataBindingExcludeGeneratedTask;
import android.databinding.tool.DataBindingExportInfoTask;
import android.databinding.tool.DataBindingProcessLayoutsTask;
import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.JavaFileWriter;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.LibraryVariantImpl;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.builder.model.ApiVersion;
import com.google.common.base.Preconditions;
import com.google.repacked.apache.commons.io.IOUtils;
import com.google.repacked.apache.commons.lang3.StringUtils;
import com.google.repacked.apache.commons.lang3.exception.ExceptionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.xml.bind.JAXBException;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;

public class DataBinderPlugin
implements Plugin<Project> {
    private static final String INVOKED_FROM_IDE_PROPERTY = "android.injected.invoked.from.ide";
    private static final String PRINT_ENCODED_ERRORS_PROPERTY = "android.databinding.injected.print.encoded.errors";
    private Logger logger;
    private boolean printEncodedErrors = false;

    /*
     * WARNING - void declaration
     */
    private boolean safeGetBooleanProperty(Project project, String property) {
        boolean bl = project.hasProperty(property);
        if (!bl) {
            return false;
        }
        try {
            void var2_2;
            if (Boolean.parseBoolean(String.valueOf(project.getProperties().get(var2_2)))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            L.w("unable to read property %s", var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean resolvePrintEncodedErrors(Project project) {
        void var1_1;
        return this.safeGetBooleanProperty(project, INVOKED_FROM_IDE_PROPERTY) || this.safeGetBooleanProperty((Project)var1_1, PRINT_ENCODED_ERRORS_PROPERTY);
    }

    /*
     * WARNING - void declaration
     */
    public void apply(Project project) {
        void var1_1;
        void var2_2;
        void var3_3;
        ExtraPropertiesExtension propExt;
        Object ext;
        if (project == null) {
            return;
        }
        this.setupLogger(project);
        String myVersion = this.readMyVersion();
        this.logD("data binding plugin version is %s", myVersion);
        if (StringUtils.isEmpty(myVersion)) {
            throw new IllegalStateException("cannot read version of the plugin :/");
        }
        this.printEncodedErrors = this.resolvePrintEncodedErrors(project);
        ScopedException.encodeOutput(this.printEncodedErrors);
        project.getDependencies().add("compile", (Object)("com.android.databinding:library:" + myVersion));
        boolean addAdapters = true;
        if (project.hasProperty("ext") && (ext = project.getProperties().get("ext")) instanceof ExtraPropertiesExtension && (propExt = (ExtraPropertiesExtension)ext).has("addDataBindingAdapters")) {
            addAdapters = Boolean.valueOf(String.valueOf(propExt.get("addDataBindingAdapters")));
        }
        if (var3_3 != false) {
            project.getDependencies().add("compile", (Object)("com.android.databinding:adapters:" + myVersion));
        }
        project.getDependencies().add("provided", (Object)("com.android.databinding:compiler:" + (String)var2_2));
        var1_1.afterEvaluate((Action)new Action<Project>(){

            /*
             * WARNING - void declaration
             */
            public void execute(Project project) {
                try {
                    DataBinderPlugin.access$200(DataBinderPlugin.this, project);
                    return;
                }
                catch (Throwable t) {
                    void var1_2;
                    DataBinderPlugin.access$100(DataBinderPlugin.this, (Throwable)var1_2, "failed to setup data binding", new Object[0]);
                    return;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void setupLogger(Project project) {
        void var1_1;
        this.logger = var1_1.getLogger();
        L.setClient(new L.Client(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void printMessage(Diagnostic.Kind kind, String message) {
                void var2_2;
                if (kind == Diagnostic.Kind.ERROR) {
                    DataBinderPlugin.access$100(DataBinderPlugin.this, null, message, new Object[0]);
                    return;
                }
                DataBinderPlugin.access$000(DataBinderPlugin.this, (String)var2_2, new Object[0]);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    String readMyVersion() {
        String string;
        InputStream stream = this.getClass().getResourceAsStream("/data_binding_build_info");
        try {
            string = IOUtils.toString(stream, "utf-8").trim();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            catch (IOException exception) {
                void var1_2;
                this.logE((Throwable)var1_2, "Cannot read data binding version", new Object[0]);
                return null;
            }
        }
        IOUtils.closeQuietly(stream);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void createXmlProcessor(Project project) throws NoSuchFieldException, IllegalAccessException {
        void var2_2;
        L.d("creating xml processor for " + project, new Object[0]);
        Object androidExt = project.getExtensions().getByName("android");
        if (!(androidExt instanceof BaseExtension)) {
            return;
        }
        if (androidExt instanceof AppExtension) {
            this.createXmlProcessorForApp(project, (AppExtension)androidExt);
            return;
        }
        if (androidExt instanceof LibraryExtension) {
            void var1_1;
            this.createXmlProcessorForLibrary((Project)var1_1, (LibraryExtension)androidExt);
            return;
        }
        this.logE(new UnsupportedOperationException("cannot understand android ext"), "unsupported android extension. What is it? %s", var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void createXmlProcessorForLibrary(Project project, LibraryExtension lib) throws NoSuchFieldException, IllegalAccessException {
        void var2_2;
        TestVariantData variantData;
        File sdkDir = lib.getSdkDirectory();
        L.d("create xml processor for " + lib, new Object[0]);
        for (TestVariant variant : lib.getTestVariants()) {
            this.logD("test variant %s. dir name %s", variant, variant.getDirName());
            variantData = this.getVariantData(variant);
            this.attachXmlProcessor(project, (BaseVariantData)variantData, sdkDir, false);
        }
        for (TestVariant variant : var2_2.getLibraryVariants()) {
            this.logD("library variant %s. dir name %s", variant, variant.getDirName());
            variantData = this.getVariantData((LibraryVariant)variant);
            this.attachXmlProcessor(project, (BaseVariantData)variantData, sdkDir, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createXmlProcessorForApp(Project project, AppExtension appExt) throws NoSuchFieldException, IllegalAccessException {
        void var2_2;
        TestVariantData variantData;
        L.d("create xml processor for " + appExt, new Object[0]);
        File sdkDir = appExt.getSdkDirectory();
        for (TestVariant testVariant : appExt.getTestVariants()) {
            variantData = this.getVariantData(testVariant);
            this.attachXmlProcessor(project, (BaseVariantData)variantData, sdkDir, false);
        }
        for (ApplicationVariant appVariant : var2_2.getApplicationVariants()) {
            variantData = this.getVariantData(appVariant);
            this.attachXmlProcessor(project, (BaseVariantData)variantData, sdkDir, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private LibraryVariantData getVariantData(LibraryVariant variant) throws NoSuchFieldException, IllegalAccessException {
        void var1_1;
        void var2_2;
        Field field = LibraryVariantImpl.class.getDeclaredField("variantData");
        field.setAccessible(true);
        return (LibraryVariantData)var2_2.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private TestVariantData getVariantData(TestVariant variant) throws IllegalAccessException, NoSuchFieldException {
        void var1_1;
        void var2_2;
        Field field = TestVariantImpl.class.getDeclaredField("variantData");
        field.setAccessible(true);
        return (TestVariantData)var2_2.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private ApplicationVariantData getVariantData(ApplicationVariant variant) throws IllegalAccessException, NoSuchFieldException {
        void var1_1;
        void var2_2;
        Field field = ApplicationVariantImpl.class.getDeclaredField("variantData");
        field.setAccessible(true);
        return (ApplicationVariantData)var2_2.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void attachXmlProcessor(Project project, final BaseVariantData variantData, final File sdkDir, Boolean isLibrary) {
        GradleVariantConfiguration configuration = variantData.getVariantConfiguration();
        final ApiVersion minSdkVersion = configuration.getMinSdkVersion();
        ProcessAndroidResources generateRTask = variantData.generateRClassTask;
        String packageName = generateRTask.getPackageForR();
        String fullName = configuration.getFullName();
        List<File> resourceFolders = Arrays.asList(variantData.mergeResourcesTask.getOutputDir());
        final File codeGenTargetFolder = new File(project.getBuildDir() + "/data-binding-info/" + configuration.getDirName());
        String writerOutBase = codeGenTargetFolder.getAbsolutePath();
        GradleFileWriter fileWriter = new GradleFileWriter(writerOutBase);
        final LayoutXmlProcessor xmlProcessor = new LayoutXmlProcessor(packageName, resourceFolders, fileWriter, minSdkVersion.getApiLevel(), isLibrary);
        final ProcessAndroidResources processResTask = generateRTask;
        final File xmlOutDir = new File(project.getBuildDir() + "/layout-info/" + configuration.getDirName());
        final File generatedClassListOut = isLibrary != false ? new File(xmlOutDir, "_generated.txt") : null;
        this.logD("xml output for %s is %s", variantData, xmlOutDir);
        String layoutTaskName = "dataBindingLayouts" + StringUtils.capitalize(processResTask.getName());
        String infoClassTaskName = "dataBindingInfoClass" + StringUtils.capitalize(processResTask.getName());
        final DataBindingProcessLayoutsTask[] processLayoutsTasks = new DataBindingProcessLayoutsTask[1];
        project.getTasks().create(layoutTaskName, DataBindingProcessLayoutsTask.class, (Action)new Action<DataBindingProcessLayoutsTask>(){

            /*
             * WARNING - void declaration
             */
            public void execute(DataBindingProcessLayoutsTask task) {
                void var1_1;
                processLayoutsTasks[0] = task;
                task.setXmlProcessor(xmlProcessor);
                task.setSdkDir(sdkDir);
                task.setXmlOutFolder(xmlOutDir);
                task.setMinSdk(minSdkVersion.getApiLevel());
                task.setBlameLogDir(variantData.getScope().getResourceBlameLogDir());
                DataBinderPlugin.access$000(DataBinderPlugin.this, "TASK adding dependency on %s for %s", new Object[]{task, processResTask});
                processResTask.dependsOn(new Object[]{task});
                processResTask.getInputs().dir((Object)xmlOutDir);
                for (Object dep : processResTask.getDependsOn()) {
                    void var3_3;
                    if (dep == task) continue;
                    DataBinderPlugin.access$000(DataBinderPlugin.this, "adding dependency on %s for %s", new Object[]{dep, task});
                    task.dependsOn(new Object[]{var3_3});
                }
                processResTask.doLast((Action)new Action<Task>((DataBindingProcessLayoutsTask)var1_1){
                    final /* synthetic */ DataBindingProcessLayoutsTask val$task;
                    {
                        this.val$task = dataBindingProcessLayoutsTask;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void execute(Task unused) {
                        try {
                            this.val$task.writeLayoutXmls();
                            return;
                        }
                        catch (JAXBException e) {
                            void var1_2;
                            DataBinderPlugin.access$100(DataBinderPlugin.this, e, "cannot write layout xmls %s", new Object[]{ExceptionUtils.getStackTrace((Throwable)var1_2)});
                            return;
                        }
                    }
                });
            }
        });
        final DataBindingProcessLayoutsTask processLayoutsTask = processLayoutsTasks[0];
        project.getTasks().create(infoClassTaskName, DataBindingExportInfoTask.class, (Action)new Action<DataBindingExportInfoTask>(){

            /*
             * WARNING - void declaration
             */
            public void execute(DataBindingExportInfoTask task) {
                void var1_1;
                task.dependsOn(new Object[]{processLayoutsTask});
                task.dependsOn(new Object[]{processResTask});
                task.setXmlProcessor(xmlProcessor);
                task.setSdkDir(sdkDir);
                task.setXmlOutFolder(xmlOutDir);
                task.setExportClassListTo(generatedClassListOut);
                task.setPrintEncodedErrors(DataBinderPlugin.this.printEncodedErrors);
                task.setEnableDebugLogs(DataBinderPlugin.this.logger.isEnabled(LogLevel.DEBUG));
                variantData.registerJavaGeneratingTask((Task)var1_1, new File[]{codeGenTargetFolder});
            }
        });
        String packageJarTaskName = "package" + StringUtils.capitalize(fullName) + "ClassesJar";
        Task packageTask = (Task)project.getTasks().findByName(packageJarTaskName);
        if (packageTask instanceof Jar) {
            String removeGeneratedTaskName = "dataBindingExcludeGeneratedFrom" + StringUtils.capitalize(packageTask.getName());
            if (project.getTasks().findByName(removeGeneratedTaskName) == null) {
                void var2_2;
                void var3_3;
                void var1_1;
                JavaCompile javaCompileTask = variantData.javacTask;
                Preconditions.checkNotNull((Object)javaCompileTask);
                var1_1.getTasks().create(removeGeneratedTaskName, DataBindingExcludeGeneratedTask.class, (Action)new Action<DataBindingExcludeGeneratedTask>((Task)var3_3, (AbstractCompile)var2_2, packageName, xmlProcessor, isLibrary, generatedClassListOut){
                    final /* synthetic */ Task val$packageTask;
                    final /* synthetic */ AbstractCompile val$javaCompileTask;
                    final /* synthetic */ String val$packageName;
                    final /* synthetic */ LayoutXmlProcessor val$xmlProcessor;
                    final /* synthetic */ Boolean val$isLibrary;
                    final /* synthetic */ File val$generatedClassListOut;
                    {
                        this.val$packageTask = task;
                        this.val$javaCompileTask = abstractCompile;
                        this.val$packageName = string;
                        this.val$xmlProcessor = layoutXmlProcessor;
                        this.val$isLibrary = bl;
                        this.val$generatedClassListOut = file;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void execute(DataBindingExcludeGeneratedTask task) {
                        void var1_1;
                        this.val$packageTask.dependsOn(new Object[]{task});
                        task.dependsOn(new Object[]{this.val$javaCompileTask});
                        task.setAppPackage(this.val$packageName);
                        task.setInfoClassQualifiedName(this.val$xmlProcessor.getInfoClassFullName());
                        task.setPackageTask((Jar)this.val$packageTask);
                        task.setLibrary(this.val$isLibrary);
                        var1_1.setGeneratedClassListFile(this.val$generatedClassListOut);
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logD(String s, Object ... args) {
        void var2_2;
        void var1_1;
        this.logger.info(this.formatLog((String)var1_1, (Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private void logE(Throwable t, String s, Object ... args) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.logger.error(this.formatLog((String)var2_2, (Object[])var3_3), (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String formatLog(String s, Object ... args) {
        void var2_2;
        void var1_1;
        return "[data binding plugin]: " + String.format((String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(DataBinderPlugin x0, String x1, Object[] x2) {
        void var2_2;
        void var1_1;
        x0.logD((String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(DataBinderPlugin x0, Throwable x1, String x2, Object[] x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.logE((Throwable)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(DataBinderPlugin x0, Project x1) throws NoSuchFieldException, IllegalAccessException {
        void var1_1;
        x0.createXmlProcessor((Project)var1_1);
    }

    class GradleFileWriter
    extends JavaFileWriter {
        private final String outputBase;

        /*
         * WARNING - void declaration
         */
        public GradleFileWriter(String outputBase) {
            void var2_2;
            this.outputBase = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeToFile(String canonicalName, String contents) {
            String asPath = canonicalName.replace('.', '/');
            File f = new File(this.outputBase + "/" + asPath + ".java");
            DataBinderPlugin.access$000(DataBinderPlugin.this, "Asked to write to " + canonicalName + ". outputting to:" + f.getAbsolutePath(), new Object[0]);
            f.getParentFile().mkdirs();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                IOUtils.write(contents, fos);
            }
            catch (IOException e) {
                try {
                    void var3_5;
                    void var2_3;
                    DataBinderPlugin.access$100(DataBinderPlugin.this, (Throwable)var2_3, "cannot write file " + var3_5.getAbsolutePath(), new Object[0]);
                }
                catch (Throwable throwable) {
                    void var1_1;
                    IOUtils.closeQuietly((OutputStream)var1_1);
                    throw throwable;
                }
                IOUtils.closeQuietly(fos);
                return;
            }
            IOUtils.closeQuietly(fos);
            return;
        }
    }
}

