/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.antlr.v4.runtime.misc;

import com.google.repacked.antlr.v4.runtime.misc.EqualityComparator;
import com.google.repacked.antlr.v4.runtime.misc.ObjectEqualityComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.abego.treelayout.Configuration;

public class FlexibleHashMap<K, V>
implements Map<K, V> {
    private EqualityComparator<? super K> comparator$64fb9e4b;
    private LinkedList<Entry<K, V>>[] buckets;
    private int n = 0;
    private int threshold = 12;
    private int currentPrime = 1;

    /*
     * WARNING - void declaration
     */
    public FlexibleHashMap(EqualityComparator<? super K> comparator) {
        this((EqualityComparator<K>)var1_1, 8);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private FlexibleHashMap(EqualityComparator<? super K> comparator, int initialBucketCapacity) {
        void var1_1;
        if (comparator == null) {
            comparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator$64fb9e4b = var1_1;
        this.buckets = FlexibleHashMap.createEntryListArray(8);
    }

    private static <K, V> LinkedList<Entry<K, V>>[] createEntryListArray(int length) {
        LinkedList[] linkedListArray = new LinkedList[length];
        return linkedListArray;
    }

    /*
     * WARNING - void declaration
     */
    private int getBucket(K key) {
        void var1_1;
        int n = this.comparator$64fb9e4b.hashCode(var1_1);
        return n &= this.buckets.length - 1;
    }

    @Override
    public V get(Object key) {
        Object typedKey = key;
        if (key == null) {
            return null;
        }
        int b = this.getBucket(typedKey);
        LinkedList<Entry<K, V>> bucket = this.buckets[b];
        if (bucket == null) {
            return null;
        }
        for (Entry entry : bucket) {
            if (!this.comparator$64fb9e4b.equals(entry.key, typedKey)) continue;
            return entry.value;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_2;
        void var1_1;
        int b;
        LinkedList<Entry<K, V>> bucket;
        if (key == null) {
            return null;
        }
        if (this.n > this.threshold) {
            FlexibleHashMap flexibleHashMap = this;
            LinkedList<Entry<K, V>>[] linkedListArray = flexibleHashMap.buckets;
            flexibleHashMap.currentPrime += 4;
            int n = flexibleHashMap.buckets.length << 1;
            LinkedList<Entry<K, V>>[] linkedListArray2 = FlexibleHashMap.createEntryListArray(n);
            flexibleHashMap.buckets = linkedListArray2;
            flexibleHashMap.threshold = (int)((double)n * 0.75);
            int n2 = flexibleHashMap.size();
            for (LinkedList<Entry<K, V>> linkedList : linkedListArray) {
                Entry entry;
                if (linkedList == null) continue;
                linkedList = linkedList.iterator();
                while (linkedList.hasNext() && (entry = (Entry)linkedList.next()) != null) {
                    flexibleHashMap.put(entry.key, entry.value);
                }
            }
            flexibleHashMap.n = n2;
        }
        if ((bucket = this.buckets[b = this.getBucket(key)]) == null) {
            this.buckets[b] = new LinkedList();
            bucket = this.buckets[b];
        }
        for (Entry entry : bucket) {
            if (!this.comparator$64fb9e4b.equals(entry.key, key)) continue;
            Object prev = entry.value;
            entry.value = value;
            ++this.n;
            return var1_1;
        }
        bucket.add(new Entry<void, void>(var1_1, var2_2));
        ++this.n;
        return null;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> values() {
        void var1_1;
        ArrayList a = new ArrayList(this.size());
        LinkedList<Entry<K, V>>[] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LinkedList<Entry<K, V>> bucket = arr$[i$];
            if (bucket == null) continue;
            for (Entry entry : bucket) {
                a.add(entry.value);
            }
        }
        return var1_1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.get(var1_1) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int n;
        int hash = 0;
        hash = 0;
        LinkedList<Entry<K, V>>[] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry e;
            LinkedList<Entry<K, V>> bucket = arr$[i$];
            if (bucket == null) continue;
            Iterator i$2 = bucket.iterator();
            while (i$2.hasNext() && (e = (Entry)i$2.next()) != null) {
                hash = Configuration.update(hash, this.comparator$64fb9e4b.hashCode(e.key));
            }
        }
        n = Configuration.finish(n, this.size());
        return n;
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public void clear() {
        this.buckets = FlexibleHashMap.createEntryListArray(16);
        this.n = 0;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean first = true;
        LinkedList<Entry<K, V>>[] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry e;
            LinkedList<Entry<K, V>> bucket = arr$[i$];
            if (bucket == null) continue;
            Iterator i$2 = bucket.iterator();
            while (i$2.hasNext() && (e = (Entry)i$2.next()) != null) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(e.toString());
            }
        }
        buf.append('}');
        return var1_1.toString();
    }

    public static final class Entry<K, V> {
        public final K key;
        public V value;

        /*
         * WARNING - void declaration
         */
        public Entry(K key, V value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }

        public final String toString() {
            return this.key.toString() + ":" + this.value.toString();
        }
    }
}

